/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.NetworkEvent;

public enum FireModeMessage {
    INSTANCE;


    public static void handler(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getSender() == null) {
                return;
            }
            FireModeMessage.changeFireMode((Player)context.getSender());
        });
        context.setPacketHandled(true);
    }

    public static void changeFireMode(Player player) {
        ItemStack stack = player.m_21205_();
        if (stack.m_41720_() instanceof GunItem) {
            GunData data = GunData.from(stack);
            CompoundTag tag = data.tag();
            FireMode fireMode = data.fireMode.get();
            Set<FireMode> mode = data.get(GunProp.AVAILABLE_FIRE_MODES);
            if (fireMode == FireMode.SEMI) {
                if (mode.contains((Object)FireMode.BURST)) {
                    data.fireMode.set(FireMode.BURST);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
                if (mode.contains((Object)FireMode.AUTO)) {
                    data.fireMode.set(FireMode.AUTO);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
            }
            if (fireMode == FireMode.BURST) {
                if (mode.contains((Object)FireMode.AUTO)) {
                    data.fireMode.set(FireMode.AUTO);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
                if (mode.contains((Object)FireMode.SEMI)) {
                    data.fireMode.set(FireMode.SEMI);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
            }
            if (fireMode == FireMode.AUTO) {
                if (mode.contains((Object)FireMode.SEMI)) {
                    data.fireMode.set(FireMode.SEMI);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
                if (mode.contains((Object)FireMode.BURST)) {
                    data.fireMode.set(FireMode.BURST);
                    FireModeMessage.playChangeModeSound(player);
                    return;
                }
            }
            if (!(stack.m_41720_() != ModItems.SENTINEL.get() || player.m_5833_() || player.m_36335_().m_41519_(stack.m_41720_()) || GunData.from((ItemStack)stack).reload.time() != 0 || GunData.from(stack).charging())) {
                for (ItemStack cell : player.m_150109_().f_35974_) {
                    if (!cell.m_150930_((Item)ModItems.CELL.get())) continue;
                    AtomicBoolean flag = new AtomicBoolean(false);
                    cell.getCapability(ForgeCapabilities.ENERGY).ifPresent(iEnergyStorage -> flag.set(iEnergyStorage.getEnergyStored() >= 0));
                    if (!flag.get()) continue;
                    data.charge.starter.markStart();
                }
            }
            if (stack.m_41720_() == ModItems.JAVELIN.get()) {
                tag.m_128379_("TopMode", !tag.m_128471_("TopMode"));
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get());
                }
            }
        }
    }

    private static void playChangeModeSound(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SoundTool.playLocalSound(serverPlayer, (SoundEvent)ModSounds.FIRE_RATE.get());
        }
    }
}

