/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.network.message.send;

import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.WeaponVehicleEntity;
import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.tools.SoundTool;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ZoomMessage {
    private final int type;

    public ZoomMessage(int type) {
        this.type = type;
    }

    public static ZoomMessage decode(FriendlyByteBuf buffer) {
        return new ZoomMessage(buffer.readInt());
    }

    public static void encode(ZoomMessage message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.type);
    }

    public static void handler(ZoomMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            VehicleEntity vehicleEntity;
            WeaponVehicleEntity weaponEntity;
            ServerPlayer player = context.getSender();
            if (player == null) {
                return;
            }
            Entity vehicle = player.m_20202_();
            if (message.type == 0 && player.m_20159_() && vehicle instanceof WeaponVehicleEntity) {
                weaponEntity = (WeaponVehicleEntity)vehicle;
                if (vehicle instanceof VehicleEntity && weaponEntity.hasWeapon((vehicleEntity = (VehicleEntity)vehicle).getSeatIndex((Entity)player)) && weaponEntity.banHand((Player)player)) {
                    SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_IN.get(), 2.0f, 1.0f);
                }
            }
            if (message.type == 1) {
                if (player.m_20159_() && vehicle instanceof WeaponVehicleEntity) {
                    weaponEntity = (WeaponVehicleEntity)vehicle;
                    if (vehicle instanceof VehicleEntity && weaponEntity.hasWeapon((vehicleEntity = (VehicleEntity)vehicle).getSeatIndex((Entity)player)) && weaponEntity.banHand((Player)player)) {
                        SoundTool.playLocalSound(player, (SoundEvent)ModSounds.CANNON_ZOOM_OUT.get(), 2.0f, 1.0f);
                    }
                }
                if (player.m_21205_().m_41720_() == ModItems.JAVELIN.get()) {
                    ItemStack handItem = player.m_21205_();
                    CompoundTag tag = handItem.m_41784_();
                    tag.m_128379_("Seeking", false);
                    tag.m_128405_("SeekTime", 0);
                    tag.m_128359_("TargetEntity", "none");
                    ClientboundStopSoundPacket clientboundstopsoundpacket = new ClientboundStopSoundPacket(new ResourceLocation("superbwarfare", "javelin_lock"), SoundSource.PLAYERS);
                    player.f_8906_.m_9829_((Packet)clientboundstopsoundpacket);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

