/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoBox;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoSupplierItem;
import com.atsuishio.superbwarfare.tools.Ammo;
import java.util.HashMap;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxAddAmmoRecipe
extends CustomRecipe {
    public AmmoBoxAddAmmoRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pContainer, @NotNull Level pLevel) {
        boolean hasAmmoBox = false;
        boolean hasAmmo = false;
        for (ItemStack item : pContainer.m_280657_()) {
            if (item.m_41720_() instanceof AmmoBox) {
                if (hasAmmoBox) {
                    return false;
                }
                hasAmmoBox = true;
                continue;
            }
            if (item.m_41720_() instanceof AmmoSupplierItem) {
                hasAmmo = true;
                continue;
            }
            if (item.m_41619_()) continue;
            return false;
        }
        return hasAmmoBox && hasAmmo;
    }

    private void addAmmo(HashMap<Ammo, Integer> map, Ammo type, int count) {
        map.put(type, map.getOrDefault((Object)type, 0) + count);
    }

    @NotNull
    public ItemStack assemble(CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        HashMap<Ammo, Integer> map = new HashMap<Ammo, Integer>();
        ItemStack ammoBox = ItemStack.f_41583_;
        for (ItemStack item : pContainer.m_280657_()) {
            Ammo[] ammoArray = item.m_41720_();
            if (ammoArray instanceof AmmoSupplierItem) {
                AmmoSupplierItem ammoSupplier = (AmmoSupplierItem)ammoArray;
                this.addAmmo(map, ammoSupplier.type, ammoSupplier.ammoToAdd);
                continue;
            }
            if (!(item.m_41720_() instanceof AmmoBox)) continue;
            ammoBox = item.m_41777_();
            for (Ammo type : Ammo.values()) {
                this.addAmmo(map, type, type.get(item));
            }
        }
        for (Ammo type : Ammo.values()) {
            type.set(ammoBox, (int)map.getOrDefault((Object)type, 0));
        }
        return ammoBox;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.AMMO_BOX_ADD_AMMO_SERIALIZER.get();
    }
}

