/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe;

import com.atsuishio.superbwarfare.init.ModItems;
import com.atsuishio.superbwarfare.init.ModRecipes;
import com.atsuishio.superbwarfare.item.common.ammo.AmmoBox;
import com.atsuishio.superbwarfare.tools.Ammo;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AmmoBoxExtractAmmoRecipe
extends CustomRecipe {
    public AmmoBoxExtractAmmoRecipe(ResourceLocation pId, CraftingBookCategory pCategory) {
        super(pId, pCategory);
    }

    public boolean matches(CraftingContainer pContainer, @NotNull Level pLevel) {
        boolean hasAmmoBox = false;
        ItemStack ammoBoxItem = ItemStack.f_41583_;
        for (ItemStack item : pContainer.m_280657_()) {
            if (item.m_41720_() instanceof AmmoBox) {
                if (hasAmmoBox) {
                    return false;
                }
                hasAmmoBox = true;
                ammoBoxItem = item;
                continue;
            }
            if (item.m_41619_()) continue;
            return false;
        }
        CompoundTag tag = ammoBoxItem.m_41783_();
        if (tag == null) {
            return false;
        }
        String typeString = tag.m_128461_("Type");
        Ammo type = Ammo.getType(typeString);
        if (type == null) {
            return false;
        }
        return type.get(ammoBoxItem) > 0;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer pContainer, @NotNull RegistryAccess pRegistryAccess) {
        Enum type = null;
        for (ItemStack item : pContainer.m_280657_()) {
            if (!(item.m_41720_() instanceof AmmoBox)) continue;
            type = Ammo.getType(item.m_41784_().m_128461_("Type"));
            break;
        }
        assert (type != null);
        return switch (1.$SwitchMap$com$atsuishio$superbwarfare$tools$Ammo[type.ordinal()]) {
            case 1 -> new ItemStack((ItemLike)ModItems.HANDGUN_AMMO.get());
            case 2 -> new ItemStack((ItemLike)ModItems.RIFLE_AMMO.get());
            case 3 -> new ItemStack((ItemLike)ModItems.SHOTGUN_AMMO.get());
            case 4 -> new ItemStack((ItemLike)ModItems.SNIPER_AMMO.get());
            case 5 -> new ItemStack((ItemLike)ModItems.HEAVY_AMMO.get());
            default -> throw new IllegalStateException("Unexpected value: " + (Ammo)type);
        };
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer pContainer) {
        NonNullList remaining = super.m_7457_((Container)pContainer);
        for (int i = 0; i < pContainer.m_6643_(); ++i) {
            ItemStack item = pContainer.m_8020_(i);
            if (!(item.m_41720_() instanceof AmmoBox)) continue;
            ItemStack ammoBox = item.m_41777_();
            Ammo type = Ammo.getType(item.m_41784_().m_128461_("Type"));
            assert (type != null);
            type.add(ammoBox, -1);
            remaining.set(i, (Object)ammoBox);
            break;
        }
        return remaining;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.AMMO_BOX_ADD_AMMO_SERIALIZER.get();
    }
}

