/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.recipe.vehicle;

import com.atsuishio.superbwarfare.Mod;
import com.atsuishio.superbwarfare.data.DeserializeFromString;
import com.google.gson.annotations.SerializedName;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class VehicleAssemblingIngredient
implements DeserializeFromString {
    @SerializedName(value="ingredient")
    String ingredientString = "";
    @SerializedName(value="count")
    int count = 1;
    public transient Ingredient ingredientObject;
    private static final Pattern INGREDIENT_PATTERN = Pattern.compile("^(?<count>(\\d+)?)\\s*(x\\s*)?(?<prefix>#?)(?<id>\\w+:\\S+)$");

    public Ingredient getIngredient() {
        if (this.ingredientObject == null) {
            this.deserializeFromString(this.ingredientString);
        }
        return this.ingredientObject;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public void deserializeFromString(String str) {
        Matcher matcher = INGREDIENT_PATTERN.matcher(str);
        if (!matcher.matches()) {
            Mod.LOGGER.warn("invalid vehicle assembling ingredient: {}", (Object)str);
            this.ingredientObject = Ingredient.f_43901_;
            return;
        }
        String countString = matcher.group("count");
        if (!countString.isEmpty()) {
            this.count = Math.max(1, Integer.parseInt(countString));
        }
        String id = matcher.group("id");
        this.ingredientObject = matcher.group("prefix").equals("#") ? Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(id))) : Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(id))});
    }
}

