/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.config.server.MiscConfig;
import com.atsuishio.superbwarfare.entity.mixin.DamageAccess;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.entity.vehicle.damage.DamageModifier;
import com.atsuishio.superbwarfare.tools.FormatTool;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;

public class DamageHandler {
    public static boolean doDamage(Entity entity, DamageSource source, float damage) {
        if (entity.m_6469_(source, damage)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            Entity entity1;
            Player player;
            LivingEntity living = (LivingEntity)entity;
            if (!((Boolean)MiscConfig.ALLOW_FORCE_DAMAGE.get()).booleanValue()) {
                return false;
            }
            if (living.m_6673_(source)) {
                return false;
            }
            if (living.m_9236_().f_46443_) {
                return false;
            }
            if (living.m_21224_()) {
                return false;
            }
            if (source.m_269533_(DamageTypeTags.f_268745_) && living.m_21023_(MobEffects.f_19607_)) {
                return false;
            }
            if (living instanceof Player && ((player = (Player)living).m_7500_() || player.m_5833_())) {
                return false;
            }
            if (living.m_5803_() && !living.m_9236_().f_46443_) {
                living.m_5796_();
            }
            living.m_21310_(0);
            DamageAccess access = DamageAccess.of(living);
            boolean flag = false;
            living.f_267362_.m_267771_(1.5f);
            boolean flag1 = true;
            if ((float)living.f_19802_ > 10.0f && !source.m_269533_(DamageTypeTags.f_273918_)) {
                if (damage <= living.f_20898_) {
                    return false;
                }
                access.superbWarfare$actuallyHurt(source, damage - living.f_20898_);
                living.f_20898_ = damage;
                flag1 = false;
            } else {
                living.f_20898_ = damage;
                living.f_19802_ = 20;
                access.superbWarfare$actuallyHurt(source, damage);
                living.f_20916_ = living.f_20917_ = 10;
            }
            if (source.m_269533_(DamageTypeTags.f_268627_) && !living.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
                access.superbWarfare$hurtHelmet(source, damage);
                damage *= 0.75f;
            }
            if ((entity1 = source.m_7639_()) != null) {
                TamableAnimal tamableEntity;
                if (entity1 instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity1;
                    if (!source.m_269533_(DamageTypeTags.f_268718_)) {
                        living.m_6703_(livingEntity);
                    }
                }
                if (entity1 instanceof Player) {
                    Player p = (Player)entity1;
                    living.f_20889_ = 100;
                    living.m_6598_(p);
                } else if (entity1 instanceof TamableAnimal && (tamableEntity = (TamableAnimal)entity1).m_21824_()) {
                    living.f_20889_ = 100;
                    LivingEntity livingEntity = tamableEntity.m_269323_();
                    if (livingEntity instanceof Player) {
                        Player player2 = (Player)livingEntity;
                        living.m_6598_(player2);
                    } else {
                        living.m_6598_(null);
                    }
                }
            }
            if (flag1) {
                living.m_9236_().m_269196_((Entity)living, source);
                if (!source.m_269533_(DamageTypeTags.f_268467_)) {
                    living.f_19864_ = true;
                }
                if (entity1 != null && !source.m_269533_(DamageTypeTags.f_268415_)) {
                    double d0 = entity1.m_20185_() - living.m_20185_();
                    double d1 = entity1.m_20189_() - living.m_20189_();
                    while (d0 * d0 + d1 * d1 < 1.0E-4) {
                        d0 = (Math.random() - Math.random()) * 0.01;
                        d1 = (Math.random() - Math.random()) * 0.01;
                    }
                    living.m_147240_((double)0.4f, d0, d1);
                    if (!flag) {
                        living.m_269405_(d0, d1);
                    }
                }
            }
            if (living.m_21224_()) {
                if (!access.superbWarfare$checkTotemDeathProtection(source)) {
                    SoundEvent soundevent = access.superbWarfare$getDeathSound();
                    if (flag1 && soundevent != null) {
                        living.m_5496_(soundevent, access.superbWarfare$getSoundVolume(), living.m_6100_());
                    }
                    living.m_6667_(source);
                }
            } else if (flag1) {
                access.superbWarfare$playHurtSound(source);
            }
            living.f_20958_ = source;
            living.f_20930_ = living.m_9236_().m_46467_();
            if (living instanceof ServerPlayer) {
                CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)living, source, damage, damage, flag);
            }
            if (entity1 instanceof ServerPlayer) {
                CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)entity1, (Entity)living, source, damage, damage, flag);
            }
            return true;
        }
        return false;
    }

    public static MutableComponent getDamageInfo(VehicleEntity vehicle, DamageSource source, float amount) {
        List<DamageModifier.ModifyResult> detailedDamageResult = vehicle.getDamageModifier().matchResult(source, amount);
        float finalDamage = detailedDamageResult.isEmpty() ? amount : detailedDamageResult.get(detailedDamageResult.size() - 1).damage();
        MutableComponent details = Component.m_237119_().m_7220_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.info.raw", (Object[])new Object[]{FormatTool.format2D(amount) + "\n"}).m_130940_(ChatFormatting.YELLOW).m_130940_(ChatFormatting.UNDERLINE)).m_7220_((Component)Component.m_237119_().m_130940_(ChatFormatting.RESET)).m_7220_((Component)DamageHandler.integrateInfo(detailedDamageResult)).m_7220_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.info.final", (Object[])new Object[]{FormatTool.format2D(finalDamage)}).m_130940_(ChatFormatting.GREEN));
        return Component.m_237113_((String)"[").m_7220_(vehicle.m_5446_()).m_7220_((Component)Component.m_237113_((String)"] ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.info.raw", (Object[])new Object[]{FormatTool.format2D(amount)}).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)" => ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237110_((String)"des.superbwarfare.vehicle_damage_analyzer.info.final", (Object[])new Object[]{FormatTool.format2D(finalDamage)}).m_130940_(ChatFormatting.GREEN)).m_130938_(style -> style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)details)));
    }

    private static MutableComponent integrateInfo(List<DamageModifier.ModifyResult> results) {
        MutableComponent info = Component.m_237119_();
        for (DamageModifier.ModifyResult result : results) {
            info = info.m_7220_((Component)result.getDamageInfo()).m_7220_((Component)Component.m_237113_((String)"\n").m_130940_(ChatFormatting.RESET));
        }
        return info;
    }
}

