/*
 * Decompiled with CFR 0.152.
 */
package com.atsuishio.superbwarfare.tools;

import com.atsuishio.superbwarfare.Mod;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagDataParser {
    public static CompoundTag parse(@Nullable JsonObject object) {
        return TagDataParser.parse(object, null);
    }

    public static CompoundTag parse(@Nullable JsonObject object, @Nullable Function<String, Tag> tagModifier) {
        CompoundTag tag = new CompoundTag();
        if (object == null) {
            return tag;
        }
        for (Map.Entry d : object.entrySet()) {
            try {
                Tag parsed = TagDataParser.parse((JsonElement)d.getValue(), tagModifier);
                if (parsed == null) continue;
                tag.m_128365_((String)d.getKey(), parsed);
            }
            catch (Exception e) {
                Mod.LOGGER.error("Failed to parse tag {}: {}", d.getKey(), (Object)e);
            }
        }
        return tag;
    }

    @Nullable
    public static Tag parse(@NotNull JsonElement object, @Nullable Function<String, Tag> tagModifier) {
        if (object.isJsonObject()) {
            CompoundTag tag = new CompoundTag();
            for (Map.Entry d : object.getAsJsonObject().entrySet()) {
                try {
                    Tag parsed = TagDataParser.parse((JsonElement)d.getValue(), tagModifier);
                    if (parsed == null) continue;
                    tag.m_128365_((String)d.getKey(), parsed);
                }
                catch (Exception e) {
                    Mod.LOGGER.error("Failed to parse tag {}: {}", d.getKey(), (Object)e);
                }
            }
            return tag;
        }
        if (object.isJsonArray()) {
            ListTag tag = new ListTag();
            for (JsonElement d : object.getAsJsonArray()) {
                tag.add((Object)TagDataParser.parse(d, tagModifier));
            }
            return tag;
        }
        if (object.isJsonPrimitive()) {
            JsonPrimitive prime = object.getAsJsonPrimitive();
            if (prime.isString()) {
                Tag tag;
                if (tagModifier != null && (tag = tagModifier.apply(prime.getAsString())) != null) {
                    return tag;
                }
                return StringTag.m_129297_((String)prime.getAsString());
            }
            if (prime.isNumber()) {
                return DoubleTag.m_128500_((double)prime.getAsLong());
            }
            if (prime.isBoolean()) {
                return ByteTag.m_128273_((boolean)prime.getAsBoolean());
            }
            return null;
        }
        return null;
    }
}

