/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.network.jei;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.client.jei.RecipeTypes;
import com.smashingmods.alchemistry.common.block.fusion.FusionControllerBlockEntity;
import com.smashingmods.alchemistry.common.block.fusion.FusionControllerMenu;
import com.smashingmods.alchemistry.common.network.jei.TransferUtils;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipe;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.network.AlchemyPacket;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class FusionTransferPacket
implements AlchemyPacket {
    private final BlockPos blockPos;
    private final ItemStack input1;
    private final ItemStack input2;
    private final boolean maxTransfer;

    public FusionTransferPacket(BlockPos pBlockPos, ItemStack pInput1, ItemStack pInput2, boolean pMaxTransfer) {
        this.blockPos = pBlockPos;
        this.input1 = pInput1;
        this.input2 = pInput2;
        this.maxTransfer = pMaxTransfer;
    }

    public FusionTransferPacket(FriendlyByteBuf pBuffer) {
        this.blockPos = pBuffer.m_130135_();
        this.input1 = pBuffer.m_130267_();
        this.input2 = pBuffer.m_130267_();
        this.maxTransfer = pBuffer.readBoolean();
    }

    public void encode(FriendlyByteBuf pBuffer) {
        pBuffer.m_130064_(this.blockPos);
        pBuffer.m_130055_(this.input1);
        pBuffer.m_130055_(this.input2);
        pBuffer.writeBoolean(this.maxTransfer);
    }

    public void handle(NetworkEvent.Context pContext) {
        ServerPlayer player = pContext.getSender();
        Objects.requireNonNull(player);
        FusionControllerBlockEntity blockEntity = (FusionControllerBlockEntity)player.m_9236_().m_7702_(this.blockPos);
        Objects.requireNonNull(blockEntity);
        ProcessingSlotHandler inputHandler = blockEntity.getInputHandler();
        ProcessingSlotHandler outputHandler = blockEntity.getOutputHandler();
        Inventory inventory = player.m_150109_();
        RecipeRegistry.getFusionRecipe(recipe -> ItemStack.m_150942_((ItemStack)recipe.getInput1(), (ItemStack)this.input1) && ItemStack.m_150942_((ItemStack)recipe.getInput2(), (ItemStack)this.input2), player.m_9236_()).ifPresent(recipe -> {
            boolean canTransfer;
            FusionRecipe recipeCopy = recipe.copy();
            inputHandler.emptyToInventory(inventory);
            outputHandler.emptyToInventory(inventory);
            boolean creative = player.f_8941_.m_9295_();
            boolean inventoryContains = inventory.m_36063_(this.input1) && inventory.m_36063_(this.input2);
            boolean bl = canTransfer = (inventoryContains || creative) && inputHandler.isEmpty() && outputHandler.isEmpty();
            if (canTransfer) {
                List<ItemStack> recipeInputs = List.of(recipeCopy.getInput1(), recipeCopy.getInput2());
                if (creative) {
                    int maxOperations = TransferUtils.getMaxOperations(recipeInputs, this.maxTransfer);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeCopy.getInput1().m_41720_(), recipeCopy.getInput1().m_41613_() * maxOperations));
                    inputHandler.setOrIncrement(1, new ItemStack((ItemLike)recipeCopy.getInput2().m_41720_(), recipeCopy.getInput2().m_41613_() * maxOperations));
                } else {
                    int slot1 = inventory.m_36030_(recipeCopy.getInput1());
                    int slot2 = inventory.m_36030_(recipeCopy.getInput2());
                    List<ItemStack> inventoryInputs = List.of(inventory.m_8020_(slot1), inventory.m_8020_(slot2));
                    int maxOperations = TransferUtils.getMaxOperations(recipeInputs, inventoryInputs, this.maxTransfer, false);
                    inventory.m_7407_(slot1, recipeCopy.getInput1().m_41613_() * maxOperations);
                    inventory.m_7407_(slot1, recipeCopy.getInput2().m_41613_() * maxOperations);
                    inputHandler.setOrIncrement(0, new ItemStack((ItemLike)recipeCopy.getInput1().m_41720_(), recipeCopy.getInput1().m_41613_() * maxOperations));
                    inputHandler.setOrIncrement(1, new ItemStack((ItemLike)recipeCopy.getInput2().m_41720_(), recipeCopy.getInput2().m_41613_() * maxOperations));
                }
                blockEntity.setProgress(0);
                blockEntity.setRecipe(recipe);
            }
        });
    }

    public static class TransferHandler
    implements IRecipeTransferHandler<FusionControllerMenu, FusionRecipe> {
        public Class<FusionControllerMenu> getContainerClass() {
            return FusionControllerMenu.class;
        }

        public Optional<MenuType<FusionControllerMenu>> getMenuType() {
            return Optional.of((MenuType)MenuRegistry.FUSION_CONTROLLER_MENU.get());
        }

        public RecipeType<FusionRecipe> getRecipeType() {
            return RecipeTypes.FUSION;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(FusionControllerMenu pContainer, FusionRecipe pRecipe, IRecipeSlotsView pRecipeSlots, Player pPlayer, boolean pMaxTransfer, boolean pDoTransfer) {
            if (pDoTransfer) {
                pContainer.getBlockEntity().setRecipe((AbstractProcessingRecipe)pRecipe);
                Alchemistry.PACKET_HANDLER.sendToServer(new FusionTransferPacket(pContainer.getBlockEntity().m_58899_(), pRecipe.getInput1(), pRecipe.getInput2(), pMaxTransfer));
            }
            return null;
        }
    }
}

