/*
 * Decompiled with CFR 0.152.
 */
package mob_grinding_utils.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import mob_grinding_utils.ModBlocks;
import mob_grinding_utils.client.ModelLayers;
import mob_grinding_utils.models.ModelTankBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public class TileTankStackItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final ResourceLocation TANK_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank.png");
    private static final ResourceLocation TANK_SINK_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank_sink.png");
    private static final ResourceLocation TANK_JUMBO_TEXTURE = new ResourceLocation("mob_grinding_utils:textures/tiles/tank_jumbo.png");
    private final ModelTankBlock tank_model;
    private FluidStack fluidStack;

    public TileTankStackItemRenderer(BlockEntityRenderDispatcher renderer, EntityModelSet modelSet) {
        super(renderer, modelSet);
        EntityModelSet EntityModelSetThatIsntNULL = Minecraft.m_91087_().m_167973_();
        this.tank_model = new ModelTankBlock(EntityModelSetThatIsntNULL.m_171103_(ModelLayers.TANK));
    }

    public void m_108829_(ItemStack stack, @Nonnull ItemDisplayContext transformType, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLight, int combinedOverlayIn) {
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.5, 0.5);
        matrixStack.m_85841_(-0.9999f, -0.9999f, 0.9999f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.tank_model.m_7695_(matrixStack, bufferIn.m_6299_(RenderType.m_110476_((ResourceLocation)this.getTexture(stack.m_41720_()))), combinedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        matrixStack.m_85849_();
        if (!stack.m_41782_() || stack.m_41783_().m_128441_("Empty")) {
            return;
        }
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41783_());
        float fluidLevel = this.fluidStack.getAmount();
        if (fluidLevel < 1.0f) {
            return;
        }
        float tankMax = 32000.0f;
        if (stack.m_41720_() == ModBlocks.JUMBO_TANK.getItem()) {
            tankMax = 1024000.0f;
        }
        float height = 0.96875f / tankMax * fluidLevel;
        IClientFluidTypeExtensions fluidExtensions = IClientFluidTypeExtensions.of((Fluid)this.fluidStack.getFluid());
        TextureAtlasSprite fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(fluidExtensions.getStillTexture());
        VertexConsumer buffer = bufferIn.m_6299_(RenderType.m_110466_());
        int fluidColor = fluidExtensions.getTintColor();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.0, 0.0);
        float yMin = 0.0f;
        float xMax = 1.984375f;
        float zMax = 1.984375f;
        float xMin = 0.015625f;
        float zMin = 0.015625f;
        yMin = 0.015625f;
        float alpha = 1.0f;
        float red = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fluidColor & 0xFF) / 255.0f;
        this.renderCuboid(buffer, matrixStack, xMax, xMin, yMin, height, zMin, zMax, fluidStillSprite, red, green, blue, alpha, combinedLight);
        matrixStack.m_85849_();
    }

    private ResourceLocation getTexture(Item item) {
        return item == ModBlocks.JUMBO_TANK.getItem() ? TANK_JUMBO_TEXTURE : (item == ModBlocks.TANK_SINK.getItem() ? TANK_SINK_TEXTURE : TANK_TEXTURE);
    }

    private void renderCuboid(VertexConsumer buffer, PoseStack matrixStack, float xMax, float xMin, float yMin, float height, float zMin, float zMax, TextureAtlasSprite textureAtlasSprite, float red, float green, float blue, float alpha, int combinedLight) {
        float uMin = textureAtlasSprite.m_118409_();
        float uMax = textureAtlasSprite.m_118410_();
        float vMin = textureAtlasSprite.m_118411_();
        float vMax = textureAtlasSprite.m_118412_();
        float vHeight = vMax - vMin;
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMin, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, height, zMax, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMax, uMin, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, height, zMin, uMax, vMin + vHeight * height, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMin, uMax, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMax, yMin, zMax, uMin, vMin, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMax, uMin, vMax, red, green, blue, alpha, combinedLight);
        this.addVertexWithUV(buffer, matrixStack, xMin, yMin, zMin, uMax, vMax, red, green, blue, alpha, combinedLight);
    }

    private void addVertexWithUV(VertexConsumer buffer, PoseStack matrixStack, float x, float y, float z, float u, float v, float red, float green, float blue, float alpha, int combinedLight) {
        buffer.m_252986_(matrixStack.m_85850_().m_252922_(), x / 2.0f, y, z / 2.0f).m_85950_(red, green, blue, alpha).m_7421_(u, v).m_7120_(combinedLight, 240).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

