/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.enderchests.common.item;

import com.google.common.base.Strings;
import java.util.List;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.enderchests.Configuration;
import shetiphian.enderchests.Roster;
import shetiphian.enderchests.Values;
import shetiphian.enderchests.client.render.RenderRegistry;
import shetiphian.enderchests.common.inventory.ContainerEnderChest;
import shetiphian.enderchests.common.inventory.ContainerProviders;
import shetiphian.enderchests.common.item.IOpenable;
import shetiphian.enderchests.common.misc.ChestInfoHelper;
import shetiphian.enderchests.common.misc.StackHelper;
import shetiphian.enderchests.common.tileentity.TileEntityEnderChest;
import shetiphian.enderchests.modintegration.curios.Curios_Base;

public class ItemEnderBag
extends Item
implements ITabFiller,
IColored,
IOpenable {
    public ItemEnderBag(Item.Properties properties) {
        super(properties);
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)this, (Object)"type", (stack, world, entity, number) -> StackHelper.isPublic(stack) ? 0.0f : (StackHelper.isTeam(stack) ? 2.0f : 1.0f)));
            RenderRegistry.OVERRIDES.add((Triple<Item, String, ItemPropertyFunction>)Triple.of((Object)this, (Object)"open", (stack, world, entity, number) -> IOpenable.isOpen(stack) ? 1.0f : 0.0f));
        });
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (String code : StackHelper.BASE_CODES) {
            entries.m_246342_(StackHelper.create(this, code, null));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue() && StackHelper.isPublic(stack)) {
            if (!((Boolean)Configuration.ACCESS_SETTINGS.allowPersonalBags.get()).booleanValue()) {
                String teamID = Function.getPlayerTeamID((Player)player);
                if (!Strings.isNullOrEmpty((String)teamID)) {
                    StackHelper.setOwner(stack, "#" + teamID);
                }
            } else {
                StackHelper.setOwner(stack, player.m_20148_().toString());
            }
        }
        IOpenable.setOpenState(stack, false);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        return this.openInventory(player.m_21120_(hand), world, player);
    }

    @Override
    public InteractionResultHolder<ItemStack> openInventory(ItemStack stack, Level world, Player player) {
        if (!world.m_5776_()) {
            BlockEntity tile;
            BlockPos pos;
            boolean isSneaking = player.m_6144_();
            BlockHitResult mop = ItemEnderBag.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            BlockPos blockPos = pos = mop instanceof BlockHitResult ? mop.m_82425_() : null;
            if (isSneaking && pos != null && world.m_8055_(pos).m_60734_() == Roster.Blocks.ENDERCHEST.get() && (tile = world.m_7702_(pos)) instanceof TileEntityEnderChest) {
                TileEntityEnderChest chestTile = (TileEntityEnderChest)tile;
                if (chestTile.hasError()) {
                    ChestInfoHelper.sendLinkError(player, 2);
                } else {
                    if (chestTile.canLink(player)) {
                        if (((Boolean)Configuration.GENERAL.fullStackLinking.get()).booleanValue()) {
                            StackHelper.setLink(stack, chestTile.getCode(), chestTile.getOwnerID());
                        } else {
                            Function.giveItem((Player)player, (ItemStack)StackHelper.setLink(stack.m_41620_(1), chestTile.getCode(), chestTile.getOwnerID()));
                        }
                        return InteractionResultHolder.m_19090_((Object)stack);
                    }
                    ChestInfoHelper.sendLinkError(player, chestTile.isTeam() ? 3 : 1);
                }
            }
            if (!StackHelper.isPublic(stack) || ((Boolean)Configuration.ACCESS_SETTINGS.allowPublicBags.get()).booleanValue()) {
                String ownerID = StackHelper.getOwnerID(stack);
                String code = StackHelper.getCode(stack);
                if (Strings.isNullOrEmpty((String)ownerID) || Strings.isNullOrEmpty((String)code)) {
                    ChestInfoHelper.sendError(player, "enderchests.bag.corrupted");
                } else {
                    String ownerName = StackHelper.getOwnerName(stack);
                    CompoundTag dataTag = new CompoundTag();
                    dataTag.m_128359_("owner.id", ownerID);
                    dataTag.m_128359_("code", code);
                    dataTag.m_128359_("owner.name", ownerName);
                    NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new ContainerProviders.EnderBag(stack, ownerName, code), buf -> {
                        buf.m_130070_(ownerID);
                        buf.m_130070_(code);
                        buf.m_130070_(ownerName);
                    });
                    IOpenable.setOpenState(stack, true);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11675_, player.m_5720_(), 1.0f, 1.0f);
                }
            } else {
                ChestInfoHelper.sendError(player, "enderchests.bag.public.disabled");
            }
        }
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        super.m_6883_(stack, world, entity, itemSlot, isSelected);
        this.iOpenableInventoryTick(stack, entity);
    }

    @Override
    public boolean isContainerOpen(Player player) {
        return player != null && player.f_36096_ instanceof ContainerEnderChest;
    }

    public String m_5671_(ItemStack stack) {
        return "item.enderchests.bag." + (StackHelper.isPublic(stack) ? "public" : (StackHelper.isTeam(stack) ? "team" : "private"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        tooltip.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237115_((String)"info.enderchests.chest.code")).m_7220_((Component)Component.m_237113_((String)(" " + StackHelper.getCode(stack)))));
        Component owner = ChestInfoHelper.formatChestOwner(StackHelper.getOwnerName(stack));
        if (owner != null) {
            tooltip.add(owner);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index > 0 && index < 4 && !data.stack.m_41619_()) {
            int value = Mth.m_14045_((int)Integer.parseInt("" + StackHelper.getCode(data.stack).charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundTag nbt) {
        return stack.m_41619_() ? null : new CapabilityProvider(stack);
    }

    private record CapabilityProvider(ItemStack stack) implements ICapabilityProvider
    {
        public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
            LazyOptional<T> curio = Curios_Base.INSTANCE.getCapability(this.stack, capability, "ender_bag");
            if (curio.isPresent()) {
                return curio;
            }
            return LazyOptional.empty();
        }
    }
}

