/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="voidscape", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static Client CLIENT_CONFIG;
    public static Common COMMON_CONFIG;

    @SubscribeEvent
    public static void onChange(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("voidscape") && event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.CLIENT_CONFIG.DONATOR.dirty = true;
        }
    }

    private static String translation(String key) {
        return "voidscape.config." + key;
    }

    public static class Client {
        public Donator DONATOR;

        public Client(ForgeConfigSpec.Builder builder) {
            builder.push("donator");
            this.DONATOR = new Donator(builder);
            builder.pop();
        }

        public static class Donator {
            public ForgeConfigSpec.BooleanValue enabled;
            public ForgeConfigSpec.IntValue color;
            public boolean dirty = true;

            private Donator(ForgeConfigSpec.Builder builder) {
                this.enabled = builder.translation(Config.translation("enabled")).comment("Enables the Donator perk wing render").define("enabled", false);
                this.color = builder.translation(Config.translation("color")).comment("Changes the Donator Wing Render Color, Format: RRGGBB Hex").defineInRange("color", 0x7700FF, Integer.MIN_VALUE, Integer.MAX_VALUE);
            }
        }
    }

    public static class Common {
        public ForgeConfigSpec.ConfigValue<List<? extends String>> bedrockTeleportationDimensionBlacklist;
        public ForgeConfigSpec.BooleanValue bedrockTeleportationDimensionWhitelist;

        public Common(ForgeConfigSpec.Builder builder) {
            this.bedrockTeleportationDimensionBlacklist = builder.translation("config.voidscape.bedrock_teleportation_dimension_blacklist").comment("Prevent standing on bedrock at low Y levels from teleporting you to the void from these dimensions\nExample: minecraft:overworld\n").defineList("bedrockTeleportationDimensionBlacklist", new ArrayList(), s -> s instanceof String);
            this.bedrockTeleportationDimensionWhitelist = builder.translation(Config.translation("bedrockTeleportationDimensionWhitelist")).comment("Changes the bedrock teleportation dimension blacklist config to be a whitelist instead").define("bedrockTeleportationDimensionWhitelist", false);
        }
    }
}

