/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import tamaized.voidscape.entity.CorruptedPawnEntity;

public class ModelCorruptedPawn<T extends CorruptedPawnEntity>
extends EntityModel<T> {
    private static final int[] CAST_MOVEMENT = new int[]{225, 315, 135, 270, 45, 180, 0, 90};
    private final ImmutableList<TransparentModelWrapper> parts;
    private final TransparentModelWrapper head;
    private final TransparentModelWrapper topTentacle;
    private final TransparentModelWrapper topRightTentacle;
    private final TransparentModelWrapper rightTentacle;
    private final TransparentModelWrapper bottomRightTentacle;
    private final TransparentModelWrapper bottomTentacle;
    private final TransparentModelWrapper bottomLeftTentacle;
    private final TransparentModelWrapper leftTentacle;
    private final TransparentModelWrapper topLeftTentacle;

    public ModelCorruptedPawn(ModelPart p_170677_) {
        this(p_170677_, RenderType::m_110473_);
    }

    public ModelCorruptedPawn(ModelPart parent, Function<ResourceLocation, RenderType> p_170680_) {
        super(p_170680_);
        ImmutableList.Builder builder = ImmutableList.builder();
        this.head = new TransparentModelWrapper(parent.m_171324_("head"));
        builder.add((Object[])new TransparentModelWrapper[]{this.head, this.topTentacle = new TransparentModelWrapper(parent.m_171324_("topTentacle")), this.topRightTentacle = new TransparentModelWrapper(parent.m_171324_("topRightTentacle")), this.rightTentacle = new TransparentModelWrapper(parent.m_171324_("rightTentacle")), this.bottomRightTentacle = new TransparentModelWrapper(parent.m_171324_("bottomRightTentacle")), this.bottomTentacle = new TransparentModelWrapper(parent.m_171324_("bottomTentacle")), this.bottomLeftTentacle = new TransparentModelWrapper(parent.m_171324_("bottomLeftTentacle")), this.leftTentacle = new TransparentModelWrapper(parent.m_171324_("leftTentacle")), this.topLeftTentacle = new TransparentModelWrapper(parent.m_171324_("topLeftTentacle"))});
        this.parts = builder.build();
    }

    public static LayerDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition definition = mesh.m_171576_();
        definition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -8.0f, -4.0f, 16.0f, 16.0f, 16.0f).m_171480_(), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("topTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)0.0f, (float)-9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)3.141593f));
        definition.m_171599_("topRightTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)-9.0f, (float)-9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)2.324799f));
        definition.m_171599_("rightTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)-9.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)1.570796f));
        definition.m_171599_("bottomRightTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)-9.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.7435722f));
        definition.m_171599_("bottomTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)0.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("bottomLeftTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)9.0f, (float)9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-0.7435801f));
        definition.m_171599_("leftTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)9.0f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-1.570796f));
        definition.m_171599_("topLeftTentacle", CubeListBuilder.m_171558_().m_171514_(0, 32).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171480_(), PartPose.m_171423_((float)9.0f, (float)-9.0f, (float)2.0f, (float)0.0f, (float)0.0f, (float)-2.324796f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.part.f_104203_ = headPitch / 57.295776f;
        this.head.part.f_104204_ = netHeadYaw / 57.295776f;
        float swing = limbSwingAmount * 4.0f;
        float swingCorner = swing * 0.45f + Mth.m_14031_((float)limbSwing) * 0.25f;
        float swingCardinal = swing * 0.95f + Mth.m_14089_((float)limbSwing) * 0.25f;
        this.topRightTentacle.part.f_104203_ = swingCorner;
        this.topLeftTentacle.part.f_104203_ = swingCorner;
        this.bottomRightTentacle.part.f_104203_ = swingCorner;
        this.bottomLeftTentacle.part.f_104203_ = swingCorner;
        this.topTentacle.part.f_104203_ = swingCardinal;
        this.leftTentacle.part.f_104203_ = swingCardinal;
        this.rightTentacle.part.f_104203_ = swingCardinal;
        this.bottomTentacle.part.f_104203_ = swingCardinal;
    }

    public void m_7695_(PoseStack p_103013_, VertexConsumer p_103014_, int p_103015_, int p_103016_, float p_103017_, float p_103018_, float p_103019_, float p_103020_) {
        this.parts.forEach(part -> {
            part.part.m_104306_(p_103013_, p_103014_, p_103015_, p_103016_, p_103017_, p_103018_, p_103019_, p_103020_ * part.alpha);
            part.alpha = 1.0f;
        });
    }

    private static class TransparentModelWrapper {
        private float alpha = 1.0f;
        private final ModelPart part;

        private TransparentModelWrapper(ModelPart part) {
            this.part = part;
        }
    }
}

