/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.world;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.portal.PortalInfo;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.ITeleporter;
import tamaized.voidscape.Voidscape;

public final class VoidTeleporter
implements ITeleporter {
    public static final VoidTeleporter INSTANCE = new VoidTeleporter();

    private VoidTeleporter() {
    }

    public Entity placeEntity(Entity oldEntity, ServerLevel currentWorld, ServerLevel destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        oldEntity.f_19789_ = 0.0f;
        return repositionEntity.apply(false);
    }

    public PortalInfo getPortalInfo(Entity oldEntity, ServerLevel destWorld, Function<ServerLevel, PortalInfo> defaultPortalInfo) {
        if (!Voidscape.checkForVoidDimension((Level)destWorld)) {
            Optional o;
            BlockPos p;
            Vec3 pos = null;
            if (oldEntity instanceof Player && (p = ((ServerPlayer)oldEntity).m_8961_()) != null && (o = Player.m_36130_((ServerLevel)destWorld, (BlockPos)p, (float)((ServerPlayer)oldEntity).m_8962_(), (boolean)((ServerPlayer)oldEntity).m_8964_(), (boolean)false)).isPresent()) {
                pos = (Vec3)o.get();
            }
            if (pos == null) {
                BlockPos bp = destWorld.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, destWorld.m_220360_());
                pos = new Vec3((double)((float)bp.m_123341_() + 0.5f), (double)((float)bp.m_123342_() + 1.0f), (double)((float)bp.m_123343_() + 0.5f));
            }
            return new PortalInfo(pos, Vec3.f_82478_, oldEntity.m_146908_(), oldEntity.m_146909_());
        }
        int scan = 2;
        int lastScan = 0;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        do {
            for (int y = -scan; y < scan; ++y) {
                for (int x = -scan; x < scan; ++x) {
                    block3: for (int z = -scan; z < scan; ++z) {
                        if (lastScan > 0 && x >= -lastScan && x <= lastScan && y >= -lastScan && y <= lastScan && z >= -lastScan && z <= lastScan) continue;
                        pos.m_122169_(oldEntity.m_20185_() + (double)x, oldEntity.m_20186_() + (double)y, oldEntity.m_20189_() + (double)z);
                        int xOff = 0;
                        int zOff = 0;
                        if (pos.m_123341_() * pos.m_123341_() + pos.m_123343_() * pos.m_123343_() <= 33800) {
                            xOff = pos.m_123341_() > 0 ? 130 : -130;
                            zOff = pos.m_123343_() > 0 ? 130 : -130;
                        }
                        pos.m_122169_(oldEntity.m_20185_() + (double)x + (double)xOff, oldEntity.m_20186_() + (double)y, oldEntity.m_20189_() + (double)z + (double)zOff);
                        if (!destWorld.m_8055_((BlockPos)pos).m_60638_((BlockGetter)destWorld, (BlockPos)pos, oldEntity, Direction.UP)) continue;
                        int height = (int)(oldEntity.m_20206_() + 1.0f);
                        for (int c = 1; c < height; ++c) {
                            pos.m_122169_(oldEntity.m_20185_() + (double)x + (double)xOff, oldEntity.m_20186_() + (double)y + (double)c, oldEntity.m_20189_() + (double)z + (double)zOff);
                            if (!destWorld.m_46859_((BlockPos)pos)) continue block3;
                        }
                        pos.m_122169_(oldEntity.m_20185_() + (double)x + (double)xOff, oldEntity.m_20186_() + (double)y, oldEntity.m_20189_() + (double)z + (double)zOff);
                        return new PortalInfo(new Vec3((double)((float)pos.m_123341_() + 0.5f), (double)(pos.m_123342_() + 1), (double)((float)pos.m_123343_() + 0.5f)), Vec3.f_82478_, oldEntity.m_146908_(), oldEntity.m_146909_());
                    }
                }
            }
            lastScan = scan;
            Voidscape.LOGGER.debug("Increasing Teleportation Scan Radius: {}", (Object)((scan *= 2) * 2));
        } while (scan * 2 < 1024);
        Voidscape.LOGGER.debug("Teleportation Scan Radius exceeds 1024, giving up.");
        return new PortalInfo(oldEntity.m_20182_(), Vec3.f_82478_, oldEntity.m_146908_(), oldEntity.m_146909_());
    }
}

