/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.container;

import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.container.AbstractMRContainerMenu;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModMenuTypes;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.upgrade.UpgradeItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class RouterMenu
extends AbstractMRContainerMenu {
    private static final int BUFFER_SLOT = 0;
    public static final int MODULE_SLOT_START = 1;
    public static final int MODULE_SLOT_END = 9;
    private static final int UPGRADE_SLOT_START = 10;
    private static final int UPGRADE_SLOT_END = 14;
    private static final int BUFFER_XPOS = 8;
    private static final int BUFFER_YPOS = 40;
    private static final int HOTBAR_XPOS = 8;
    private static final int HOTBAR_YPOS = 162;
    private static final int PLAYER_INVENTORY_XPOS = 8;
    private static final int PLAYER_INVENTORY_YPOS = 104;
    public static final int MODULE_XPOS = 8;
    private static final int MODULE_YPOS = 72;
    public static final int UPGRADE_XPOS = 80;
    private static final int UPGRADE_YPOS = 40;
    public static final int TE_FIRST_SLOT = 36;
    private static final int TE_LAST_SLOT = 50;
    private final ModularRouterBlockEntity router;
    public final ModularRouterBlockEntity.TrackedEnergy data;

    public RouterMenu(int windowId, Inventory invPlayer, FriendlyByteBuf extraData) {
        this(windowId, invPlayer, extraData.m_130135_());
    }

    public RouterMenu(int windowId, Inventory invPlayer, BlockPos routerPos) {
        super((MenuType)ModMenuTypes.ROUTER_MENU.get(), windowId);
        int slot;
        this.router = (ModularRouterBlockEntity)invPlayer.f_35978_.m_9236_().m_141902_(routerPos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).orElseThrow(() -> new IllegalStateException("router missing at " + routerPos));
        this.data = this.router.trackedEnergy;
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)invPlayer, x, 8 + 18 * x, 162));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotNumber = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 104 + y * 18;
                this.m_38897_(new Slot((Container)invPlayer, slotNumber, xpos, ypos));
            }
        }
        this.m_38897_((Slot)new SlotItemHandler(this.router.getBuffer(), 0, 8, 40));
        for (slot = 0; slot < this.router.getModuleSlotCount(); ++slot) {
            this.m_38897_((Slot)new InstalledModuleSlot(this.router.getModules(), slot, 8 + slot * 18, 72));
        }
        for (slot = 0; slot < this.router.getUpgradeSlotCount(); ++slot) {
            this.m_38897_((Slot)new SlotItemHandler(this.router.getUpgrades(), slot, 80 + slot * 18, 40));
        }
        this.m_38884_(this.data);
    }

    public boolean m_6875_(Player player) {
        return !this.router.m_58901_() && Vec3.m_82512_((Vec3i)this.router.m_58899_()).m_82557_(player.m_20182_()) <= 64.0;
    }

    public ItemStack m_7648_(Player player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.f_38839_.get(sourceSlotIndex);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (sourceSlotIndex < 36) {
            if (sourceStack.m_41720_() instanceof ModuleItem ? !this.m_38903_(sourceStack, 37, 46, false) : (sourceStack.m_41720_() instanceof UpgradeItem ? !this.m_38903_(sourceStack, 46, 51, false) : !this.m_38903_(sourceStack, 36, 37, false))) {
                return ItemStack.f_41583_;
            }
        } else if (sourceSlotIndex < 86) {
            if (!this.m_38903_(sourceStack, 0, 35, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.err.print("Invalid moduleSlotIndex: " + sourceSlotIndex);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41619_()) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(player, sourceStack);
        return copyOfSourceStack;
    }

    public ModularRouterBlockEntity getRouter() {
        return this.router;
    }

    public static class InstalledModuleSlot
    extends SlotItemHandler {
        InstalledModuleSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
            super(itemHandler, index, xPosition, yPosition);
        }
    }
}

