/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.module.TargetedModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.BeamData;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class CompiledEnergyDistributorModule
extends CompiledModule {
    public CompiledEnergyDistributorModule(@Nullable ModularRouterBlockEntity router, ItemStack stack) {
        super(router, stack);
    }

    @Override
    public boolean execute(@Nonnull ModularRouterBlockEntity router) {
        List<ModuleTarget> inRange = this.getTargets().stream().filter(target -> target.isSameWorld(router.m_58904_()) && router.m_58899_().m_123331_((Vec3i)target.gPos.m_122646_()) <= (double)this.getRangeSquared()).toList();
        if (inRange.isEmpty()) {
            return false;
        }
        int total = router.getCapability(ForgeCapabilities.ENERGY).map(routerHandler -> {
            int toSend = routerHandler.getEnergyStored() / inRange.size();
            int total1 = 0;
            boolean doBeam = router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2;
            for (ModuleTarget target : inRange) {
                total1 += target.getEnergyHandler().map(handler -> {
                    int toExtract = routerHandler.extractEnergy(toSend, true);
                    int sent = handler.receiveEnergy(toExtract, false);
                    routerHandler.extractEnergy(sent, false);
                    if (sent > 0 && doBeam) {
                        router.addItemBeam(new BeamData(router.getTickRate(), target.gPos.m_122646_(), 0xE04040));
                    }
                    return sent;
                }).orElse(0).intValue();
            }
            return total1;
        }).orElse(0);
        return total > 0;
    }

    @Override
    public List<ModuleTarget> setupTargets(ModularRouterBlockEntity router, ItemStack stack) {
        return router == null ? Collections.emptyList() : ImmutableList.copyOf(TargetedModule.getTargets(stack, !router.m_58904_().f_46443_));
    }
}

