/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.easyvillagers.items.render;

import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.easyvillagers.ItemTileEntityCache;
import de.maxhenkel.easyvillagers.blocks.tileentity.FakeWorldTileentity;
import de.maxhenkel.easyvillagers.corelib.client.ItemRenderer;
import de.maxhenkel.easyvillagers.corelib.client.RendererProviders;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class BlockItemRendererBase<T extends BlockEntityRenderer<U>, U extends FakeWorldTileentity>
extends ItemRenderer {
    private final Function<BlockEntityRendererProvider.Context, T> rendererSupplier;
    private final Supplier<U> tileEntitySupplier;
    private T renderer;

    public BlockItemRendererBase(Function<BlockEntityRendererProvider.Context, T> rendererSupplier, Supplier<U> tileentitySupplier) {
        this.rendererSupplier = rendererSupplier;
        this.tileEntitySupplier = tileentitySupplier;
    }

    @Override
    public void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Item item;
        if (this.renderer == null) {
            this.renderer = (BlockEntityRenderer)this.rendererSupplier.apply(RendererProviders.createBlockEntityRendererContext());
        }
        if ((item = itemStack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            this.minecraft.m_91289_().m_110912_(blockItem.m_40614_().m_49966_(), matrixStack, buffer, combinedLightIn, combinedOverlayIn);
        }
        this.renderer.m_6922_(ItemTileEntityCache.getTileEntity(itemStack, this.tileEntitySupplier), 0.0f, matrixStack, buffer, combinedLightIn, combinedOverlayIn);
    }
}

