/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Alignment;
import com.ldtteam.blockui.Loader;
import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.util.SafeError;
import com.ldtteam.blockui.util.records.SizeI;
import com.ldtteam.blockui.views.ScrollingContainer;
import com.ldtteam.blockui.views.ScrollingList;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScrollingListContainer
extends ScrollingContainer {
    @NotNull
    private final Text emptyTextComponent;
    @Nullable
    private PaneParams listNodeParams;
    private SizeI templateSize = new SizeI(0, 0);

    ScrollingListContainer(ScrollingList owner) {
        super(owner);
        this.emptyTextComponent = new Text();
        this.emptyTextComponent.setSize(this.width, this.height);
        this.emptyTextComponent.setTextAlignment(Alignment.MIDDLE);
    }

    public void setEmptyText(List<MutableComponent> emptyText) {
        this.emptyTextComponent.setText(emptyText);
    }

    public void setEmptyTextColor(int emptyTextColor) {
        this.emptyTextComponent.setColors(emptyTextColor);
    }

    public void setEmptyTextScale(double emptyTextScale) {
        this.emptyTextComponent.setTextScale(emptyTextScale);
    }

    public void setListNodeParams(@NotNull PaneParams listNodeParams) {
        this.listNodeParams = listNodeParams;
        listNodeParams.setParentView(this);
        listNodeParams.getScaledInteger("size", listNodeParams.getParentWidth(), listNodeParams.getParentHeight(), a -> {
            this.templateSize = new SizeI((Integer)a.get(0), (Integer)a.get(1));
        });
    }

    public void refreshElementPanes(ScrollingList.DataProvider dataProvider, int height, int childSpacing, boolean force) {
        int numElements;
        if (dataProvider == null) {
            return;
        }
        int currentYpos = 0;
        if (this.listNodeParams == null) {
            SafeError.throwInDev(new IllegalStateException("Template size is not defined. Does the scrolling list have a child?"));
            return;
        }
        if (!force && !dataProvider.shouldUpdate()) {
            return;
        }
        if (this.width != this.emptyTextComponent.getWidth() || this.height != this.emptyTextComponent.getHeight()) {
            this.emptyTextComponent.setSize(this.width, this.height);
        }
        if ((numElements = dataProvider.getElementCount()) > 0) {
            if (this.emptyTextComponent.getParent() != null) {
                this.removeChild(this.emptyTextComponent);
            }
            RowSizeModifier modifier = new RowSizeModifier();
            for (int i = 0; i < numElements; ++i) {
                modifier.reset(this.templateSize.width(), this.templateSize.height());
                dataProvider.modifyRowSize(i, modifier);
                int elementHeight = modifier.height;
                if ((double)(currentYpos + elementHeight) >= this.scrollY && (double)currentYpos <= this.scrollY + (double)height) {
                    Pane child;
                    if (i < this.children.size()) {
                        child = (Pane)this.children.get(i);
                    } else {
                        child = Loader.createFromPaneParams(this.listNodeParams, this);
                        if (child == null) continue;
                    }
                    child.setPosition(0, currentYpos);
                    if (modifier.modified) {
                        child.setSize(modifier.width, modifier.height);
                    }
                    if (force || dataProvider.shouldUpdate(i)) {
                        dataProvider.updateElement(i, child);
                    }
                }
                currentYpos += elementHeight + childSpacing;
            }
            while (this.children.size() > numElements) {
                this.removeChild((Pane)this.children.get(numElements));
            }
        } else if (this.emptyTextComponent.getParent() == null) {
            this.children.clear();
            this.addChild(this.emptyTextComponent);
        }
        this.setContentHeight(currentYpos - childSpacing);
    }

    public int getListElementIndexByPane(Pane pane) {
        Pane parentPane;
        for (parentPane = pane; parentPane != null && parentPane.getParent() != this; parentPane = parentPane.getParent()) {
        }
        if (parentPane == null) {
            return -1;
        }
        return this.getChildren().indexOf(parentPane);
    }

    public static class RowSizeModifier {
        private int width;
        private int height;
        private boolean modified;

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.setSize(width, this.height);
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.setSize(this.width, height);
        }

        public void adjustSize(int diffW, int diffH) {
            this.setSize(this.width + diffW, this.height + diffH);
        }

        public void setSize(int width, int height) {
            this.width = width;
            this.height = height;
            this.modified = true;
        }

        void reset(int width, int height) {
            this.width = width;
            this.height = height;
            this.modified = false;
        }
    }
}

