/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.ToggleButton;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.rftoolsbase.api.control.parameters.ParameterType;
import mcjty.rftoolsbase.api.control.parameters.ParameterValue;
import mcjty.rftoolscontrol.modules.processor.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.modules.processor.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;

public class LongEditor
extends AbstractParameterEditor {
    private TextField field;
    private ToggleButton hexMode;

    @Override
    public void build(Minecraft mc, Screen gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = Widgets.horizontal();
        this.field = new TextField().event(newText -> callback.valueChanged(this.readValue())).addTextEnterEvent(newText -> this.closeWindow());
        constantPanel.children(new Widget[]{this.field});
        this.hexMode = (ToggleButton)new ToggleButton().event(this::updateHex).checkMarker(true).text("Hex");
        constantPanel.children(new Widget[]{this.hexMode});
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_LONG);
    }

    private void updateHex() {
        Long i;
        Object value = this.field.getText();
        if (this.hexMode.isPressed()) {
            if (!((String)value).startsWith("$")) {
                try {
                    long i2 = Long.parseLong((String)value);
                    value = "$" + Long.toHexString(i2);
                    this.field.text((String)value);
                }
                catch (NumberFormatException i2) {}
            }
        } else if (((String)value).startsWith("$") && (i = LongEditor.parseLongSafe((String)value)) != null) {
            this.field.text(String.valueOf(i));
        }
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)LongEditor.parseLongSafe(this.field.getText()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.text("");
        } else {
            try {
                this.field.text(Long.toString((Long)value.getValue()));
            }
            catch (Exception e) {
                this.field.text("");
            }
        }
        this.updateHex();
    }
}

