/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.SafeClientTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.network.PacketLogReady;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGetLog(ResourceKey<Level> dimension, BlockPos pos, String command, TypedMap params, boolean fromTablet) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolscontrol", "getlog");

    public static PacketGetLog create(FriendlyByteBuf buf) {
        return new PacketGetLog((ResourceKey<Level>)LevelTools.getId((ResourceLocation)buf.m_130281_()), buf.m_130135_(), buf.m_130277_(), TypedMapTools.readArguments((FriendlyByteBuf)buf), buf.readBoolean());
    }

    public static PacketGetLog create(ResourceKey<Level> dimension, BlockPos pos, boolean fromTablet) {
        return new PacketGetLog(dimension, pos, ProcessorTileEntity.CMD_GETLOG.name(), TypedMap.EMPTY, fromTablet);
    }

    public static PacketGetLog create(ResourceKey<Level> dimension, BlockPos pos, String cmd, @Nonnull TypedMap params) {
        return new PacketGetLog(dimension, pos, cmd, params, false);
    }

    public static PacketGetLog create(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        return new PacketGetLog((ResourceKey<Level>)SafeClientTools.getWorld().m_46472_(), pos, cmd, params, false);
    }

    public static PacketGetLog create(BlockPos pos, String cmd) {
        return new PacketGetLog((ResourceKey<Level>)SafeClientTools.getWorld().m_46472_(), pos, cmd, TypedMap.EMPTY, false);
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments((FriendlyByteBuf)buf, (TypedMap)this.params);
        buf.writeBoolean(this.fromTablet);
    }

    public ResourceLocation id() {
        return ID;
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            BlockEntity te;
            ServerLevel world = LevelTools.getLevel((Level)player.m_20193_(), this.dimension);
            if (world.m_46805_(this.pos) && (te = world.m_7702_(this.pos)) instanceof GenericTileEntity) {
                List list = ((GenericTileEntity)te).executeServerCommandList(ProcessorTileEntity.CMD_GETLOG.name(), player, this.params, String.class);
                if (this.fromTablet) {
                    RFToolsCtrlMessages.sendToPlayer(new PacketLogReady(null, ProcessorTileEntity.CMD_GETLOG.name(), list), player);
                } else {
                    RFToolsCtrlMessages.sendToPlayer(new PacketLogReady(this.pos, ProcessorTileEntity.CMD_GETLOG.name(), list), player);
                }
            }
        }));
    }
}

