/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.integrations.emi;

import dev.emi.emi.api.forge.ForgeEmiStack;
import dev.emi.emi.api.recipe.BasicEmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import mods.railcraft.api.core.RailcraftConstants;
import mods.railcraft.integrations.emi.RailcraftEmiPlugin;
import mods.railcraft.world.item.crafting.CokeOvenRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;

public class CokeOvenEmiRecipe
extends BasicEmiRecipe {
    private static final int WIDTH = 124;
    private static final int HEIGHT = 49;
    private static final ResourceLocation BACKGROUND = RailcraftConstants.rl("textures/gui/container/coke_oven.png");
    private final CokeOvenRecipe recipe;

    public CokeOvenEmiRecipe(CokeOvenRecipe recipe) {
        super(RailcraftEmiPlugin.COKING_CATEGORY, recipe.m_6423_(), 124, 49);
        this.recipe = recipe;
        this.inputs.add(EmiIngredient.of((Ingredient)((Ingredient)recipe.m_7527_().get(0))));
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        this.outputs.add(EmiStack.of((ItemStack)recipe.m_8043_(level.m_9598_())));
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(BACKGROUND, 0, 0, this.width, this.height, 15, 23);
        widgets.addFillingArrow(18, 20, 10000).tooltip((x, y) -> {
            int cookTime = this.recipe.m_43753_();
            if (cookTime > 0) {
                int cookTimeSeconds = cookTime / 20;
                MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
                return List.of(EmiTooltipComponents.of((Component)timeString));
            }
            return List.of(EmiTooltipComponents.of((Component)Component.m_237119_()));
        });
        widgets.addAnimatedTexture(EmiTexture.FULL_FLAME, 1, 3, 10000, false, true, true);
        widgets.addSlot((EmiIngredient)this.inputs.get(0), 0, 19);
        widgets.addSlot((EmiIngredient)this.outputs.get(0), 42, 15).large(true).recipeContext((EmiRecipe)this);
        EmiStack fluid = ForgeEmiStack.of((FluidStack)this.recipe.getCreosote());
        widgets.addTank((EmiIngredient)fluid, 74, 0, 50, 49, 10000).drawBack(false).recipeContext((EmiRecipe)this);
    }
}

