/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class BoxBuilder {
    public static final AABB FULL_BOX = BoxBuilder.create().box().build();
    public static final double PIXEL = 0.0625;
    private double minX;
    private double minY;
    private double minZ;
    private double maxX;
    private double maxY;
    private double maxZ;

    private BoxBuilder() {
    }

    public static BoxBuilder create() {
        return new BoxBuilder();
    }

    public AABB build() {
        return new AABB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public BoxBuilder fromAABB(AABB box) {
        return this.setBounds(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_);
    }

    public BoxBuilder box() {
        return this.setBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public BoxBuilder setBounds(double x1, double y1, double z1, double x2, double y2, double z2) {
        this.minX = Math.min(x1, x2);
        this.minY = Math.min(y1, y2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxY = Math.max(y1, y2);
        this.maxZ = Math.max(z1, z2);
        return this;
    }

    public BoxBuilder setBoundsToPoint(Vec3i vector) {
        this.minX = vector.m_123341_();
        this.minY = vector.m_123342_();
        this.minZ = vector.m_123343_();
        this.maxX = vector.m_123341_();
        this.maxY = vector.m_123342_();
        this.maxZ = vector.m_123343_();
        return this;
    }

    public BoxBuilder setBoundsFromBlock(BlockState state, BlockGetter world, BlockPos pos) {
        VoxelShape shape = state.m_60808_(world, pos);
        this.setBounds((double)pos.m_123341_() + shape.m_83288_(Direction.Axis.X), (double)pos.m_123342_() + shape.m_83288_(Direction.Axis.Y), (double)pos.m_123343_() + shape.m_83288_(Direction.Axis.Z), (double)pos.m_123341_() + shape.m_83297_(Direction.Axis.X), (double)pos.m_123342_() + shape.m_83297_(Direction.Axis.Y), (double)pos.m_123343_() + shape.m_83297_(Direction.Axis.Z));
        return this;
    }

    public BoxBuilder at(BlockPos pos) {
        this.setBounds(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1);
        return this;
    }

    public BoxBuilder at(BlockPos pos, double grow) {
        this.setBounds((double)pos.m_123341_() - grow, (double)pos.m_123342_() - grow, (double)pos.m_123343_() - grow, (double)pos.m_123341_() + 1.0 + grow, (double)pos.m_123342_() + 1.0 + grow, (double)pos.m_123343_() + 1.0 + grow);
        return this;
    }

    public BoxBuilder inflate(double distance) {
        this.minX -= distance;
        this.minY -= distance;
        this.minZ -= distance;
        this.maxX += distance;
        this.maxY += distance;
        this.maxZ += distance;
        return this;
    }

    public BoxBuilder clampToWorld() {
        return this;
    }

    public BoxBuilder inflateHorizontally(double distance) {
        this.minX -= distance;
        this.minZ -= distance;
        this.maxX += distance;
        this.maxZ += distance;
        return this;
    }

    public BoxBuilder expandXAxis(double distance) {
        this.minX -= distance;
        this.maxX += distance;
        return this;
    }

    public BoxBuilder expandYAxis(double distance) {
        this.minY -= distance;
        this.maxY += distance;
        return this;
    }

    public BoxBuilder expandZAxis(double distance) {
        this.minZ -= distance;
        this.maxZ += distance;
        return this;
    }

    public BoxBuilder expandAxis(Direction.Axis axis, double distance) {
        switch (axis) {
            case X: {
                this.expandXAxis(distance);
                break;
            }
            case Y: {
                this.expandYAxis(distance);
                break;
            }
            case Z: {
                this.expandZAxis(distance);
            }
        }
        return this;
    }

    public BoxBuilder raiseFloor(double raise) {
        this.minY += raise;
        return this;
    }

    public BoxBuilder raiseCeiling(double raise) {
        this.maxY += raise;
        return this;
    }

    public BoxBuilder raiseCeilingPixel(int raise) {
        this.maxY += (double)raise * 0.0625;
        return this;
    }

    public BoxBuilder shiftY(double shift) {
        this.minY += shift;
        this.maxY += shift;
        return this;
    }

    public BoxBuilder expandToCoordinate(Vec3 point) {
        return this.expandToCoordinate(point.m_7096_(), point.m_7098_(), point.m_7094_());
    }

    public BoxBuilder expandToCoordinate(BlockPos point) {
        return this.expandToCoordinate(point.m_123341_(), point.m_123342_(), point.m_123343_());
    }

    public BoxBuilder expandToCoordinate(double x, double y, double z) {
        if (x < this.minX) {
            this.minX = x;
        } else if (x > this.maxX) {
            this.maxX = x;
        }
        if (y < this.minY) {
            this.minY = y;
        } else if (y > this.maxY) {
            this.maxY = y;
        }
        if (z < this.minZ) {
            this.minZ = z;
        } else if (z > this.maxZ) {
            this.maxZ = z;
        }
        return this;
    }

    public BoxBuilder offset(Vec3i pos) {
        return this.offset(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BoxBuilder offset(double x, double y, double z) {
        this.minX += x;
        this.minY += y;
        this.minZ += z;
        this.maxX += x;
        this.maxY += y;
        this.maxZ += z;
        return this;
    }

    public BoxBuilder setMinY(double minY) {
        this.minY = minY;
        return this;
    }

    public BoxBuilder setMaxY(double maxY) {
        this.maxY = maxY;
        return this;
    }

    public BoxBuilder upTo(double distance) {
        this.minX -= distance;
        this.minZ -= distance;
        this.maxX += distance;
        this.maxY += distance;
        this.maxZ += distance;
        return this;
    }

    public boolean isUndefined() {
        return this.minX == this.maxX || this.minY == this.maxY || this.minZ == this.maxZ;
    }

    public String toString() {
        return String.format("{%.1f,%.1f,%.1f} - {%.1f,%.1f,%.1f}", this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }
}

