/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.util.routing.expression.condition;

import java.util.Locale;
import mods.railcraft.Translations;
import mods.railcraft.api.carts.Paintable;
import mods.railcraft.util.routing.RoutingLogicException;
import mods.railcraft.util.routing.RoutingStatementParser;
import mods.railcraft.util.routing.expression.Expression;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.DyeColor;

public class ColorCondition {
    public static final String KEYWORD = "Color";

    public static Expression parse(String line) throws RoutingLogicException {
        RoutingStatementParser.ParsedStatement statement = RoutingStatementParser.parse(KEYWORD, false, line);
        String[] colors = statement.value().toLowerCase(Locale.ROOT).split(",");
        DyeColor primary = ColorCondition.parseColor(colors[0]);
        DyeColor secondary = colors.length < 2 ? null : ColorCondition.parseColor(colors[1]);
        return (router, rollingStock) -> {
            AbstractMinecart patt866$temp = rollingStock.entity();
            if (patt866$temp instanceof Paintable) {
                Paintable paintable = (Paintable)patt866$temp;
                return !(primary != null && !primary.equals((Object)paintable.getPrimaryDyeColor()) || secondary != null && !secondary.equals((Object)paintable.getSecondaryDyeColor()));
            }
            return false;
        };
    }

    private static DyeColor parseColor(String name) throws RoutingLogicException {
        if ("Any".equals(name) || "*".equals(name)) {
            return null;
        }
        DyeColor color = DyeColor.m_41057_((String)name, null);
        if (color == null) {
            throw new RoutingLogicException(Translations.RoutingTable.UNRECOGNIZED_KEYWORD, name);
        }
        return color;
    }
}

