/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.item.crafting;

import java.util.function.Predicate;
import java.util.stream.IntStream;
import mods.railcraft.world.item.RailcraftItems;
import mods.railcraft.world.item.crafting.RailcraftRecipeSerializers;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TicketDuplicateRecipe
extends CustomRecipe {
    private static final Ingredient SOURCE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.GOLDEN_TICKET.get()});
    private static final Ingredient BLANK = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_});

    public TicketDuplicateRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer container, Level level) {
        int numBlank = 0;
        int numSource = 0;
        for (int slot = 0; slot < container.m_6643_(); ++slot) {
            ItemStack stack = container.m_8020_(slot);
            if (stack.m_41619_()) continue;
            if (numSource == 0 && SOURCE.test(stack)) {
                ++numSource;
                continue;
            }
            if (BLANK.test(stack)) {
                ++numBlank;
                continue;
            }
            return false;
        }
        return numSource == 1 && numBlank == 1;
    }

    public ItemStack assemble(CraftingContainer container, RegistryAccess registryAccess) {
        CompoundTag nbt;
        ItemStack source = IntStream.range(0, container.m_6643_()).mapToObj(arg_0 -> ((CraftingContainer)container).m_8020_(arg_0)).filter((Predicate<ItemStack>)SOURCE).findFirst().orElse(ItemStack.f_41583_);
        ItemStack result = this.m_8043_(registryAccess);
        if (!source.m_41619_() && (nbt = source.m_41783_()) != null) {
            result.m_41751_(nbt.m_6426_());
        }
        return result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList ingredients = NonNullList.m_122779_();
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)RailcraftItems.GOLDEN_TICKET.get()}));
        ingredients.add((Object)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42516_}));
        return ingredients;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return new ItemStack((ItemLike)RailcraftItems.TICKET.get());
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RailcraftRecipeSerializers.TICKET_DUPLICATE.get();
    }
}

