/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.entity.signal;

import mods.railcraft.api.signal.BlockSignalEntity;
import mods.railcraft.api.signal.SignalAspect;
import mods.railcraft.api.signal.SimpleBlockSignalNetwork;
import mods.railcraft.api.signal.SimpleSignalController;
import mods.railcraft.api.signal.entity.SignalControllerEntity;
import mods.railcraft.world.level.block.entity.RailcraftBlockEntityTypes;
import mods.railcraft.world.level.block.entity.signal.AbstractSignalBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockSignalBlockEntity
extends AbstractSignalBlockEntity
implements SignalControllerEntity,
BlockSignalEntity {
    private final SimpleSignalController signalController = new SimpleSignalController(1, this::syncToClient, this, false, __ -> this.f_58857_.m_5518_().m_7174_(this.m_58899_()));
    private final SimpleBlockSignalNetwork blockSignal = new SimpleBlockSignalNetwork(1, this::syncToClient, this.signalController::setSignalAspect, (BlockEntity)this);

    public BlockSignalBlockEntity(BlockPos blockPos, BlockState blockState) {
        this((BlockEntityType)RailcraftBlockEntityTypes.BLOCK_SIGNAL.get(), blockPos, blockState);
    }

    public BlockSignalBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
    }

    public void blockRemoved() {
        this.signalController.destroy();
        this.blockSignal.destroy();
    }

    public void onLoad() {
        super.onLoad();
        if (!this.f_58857_.m_5776_()) {
            this.signalController.refresh();
            this.blockSignal.refresh();
        }
    }

    @Override
    public SignalAspect getPrimarySignalAspect() {
        return this.blockSignal.aspect();
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("blockSignal", (Tag)this.blockSignal.serializeNBT());
        tag.m_128365_("signalController", (Tag)this.signalController.serializeNBT());
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.blockSignal.deserializeNBT(tag.m_128469_("blockSignal"));
        this.signalController.deserializeNBT(tag.m_128469_("signalController"));
    }

    @Override
    public void writeToBuf(FriendlyByteBuf data) {
        super.writeToBuf(data);
        this.blockSignal.writeToBuf(data);
        this.signalController.writeToBuf(data);
    }

    @Override
    public void readFromBuf(FriendlyByteBuf data) {
        super.readFromBuf(data);
        this.blockSignal.readFromBuf(data);
        this.signalController.readFromBuf(data);
    }

    @Override
    public SimpleSignalController getSignalController() {
        return this.signalController;
    }

    @Override
    public SimpleBlockSignalNetwork signalNetwork() {
        return this.blockSignal;
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, BlockSignalBlockEntity blockEntity) {
        blockEntity.signalController.spawnTuningAuraParticles();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, BlockSignalBlockEntity blockEntity) {
        blockEntity.blockSignal.serverTick();
    }
}

