/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.behaivor;

import java.util.HashSet;
import java.util.Set;
import mods.railcraft.api.track.TrackUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TrackSupportTools {
    public static boolean isSupportedDirectly(BlockGetter level, BlockPos pos) {
        return Block.m_49936_((BlockGetter)level, (BlockPos)pos.m_7495_());
    }

    public static boolean isSupported(Level level, BlockPos pos) {
        return TrackSupportTools.isSupported((LevelReader)level, pos, 2);
    }

    public static boolean isSupported(LevelReader level, BlockPos pos, int maxDistance) {
        return maxDistance == 0 ? TrackSupportTools.isSupportedDirectly((BlockGetter)level, pos) : TrackSupportTools.isSupported(level, pos, false, maxDistance, new HashSet<BlockPos>());
    }

    private static boolean isSupported(LevelReader level, BlockPos pos, boolean checkSelf, int distance, Set<BlockPos> checked) {
        if (checked.contains(pos)) {
            return false;
        }
        checked.add(pos);
        if (!level.m_46805_(pos)) {
            return true;
        }
        if (checkSelf && !BaseRailBlock.m_49416_((BlockState)level.m_8055_(pos))) {
            return false;
        }
        if (TrackSupportTools.isSupportedDirectly((BlockGetter)level, pos)) {
            return true;
        }
        if (distance <= 0) {
            return false;
        }
        --distance;
        for (BlockPos connectedTrack : TrackUtil.getConnectedTracks(level, pos)) {
            if (!TrackSupportTools.isSupported(level, connectedTrack, true, distance, checked)) continue;
            return true;
        }
        return false;
    }
}

