/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.world.level.block.track.outfitted;

import java.util.Arrays;
import java.util.function.Supplier;
import mods.railcraft.api.item.Crowbar;
import mods.railcraft.api.track.TrackType;
import mods.railcraft.api.track.TrackUtil;
import mods.railcraft.world.level.block.track.TrackBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.IFluidBlock;

public class OutfittedTrackBlock
extends TrackBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;

    public OutfittedTrackBlock(Supplier<? extends TrackType> trackType, BlockBehaviour.Properties properties) {
        super(trackType, properties);
    }

    @Override
    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        Crowbar crowbar;
        ItemStack itemStack = player.m_21120_(hand);
        Item item = itemStack.m_41720_();
        if (item instanceof Crowbar && (crowbar = (Crowbar)item).canWhack(player, hand, itemStack, pos) && this.crowbarWhack(state, level, pos, player, hand, itemStack)) {
            crowbar.onWhack(player, hand, itemStack, pos);
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return InteractionResult.PASS;
    }

    protected boolean crowbarWhack(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack itemStack) {
        return false;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockState newState = TrackUtil.setShape(this.getTrackType().getFlexBlock(), TrackUtil.getRailShapeRaw(state));
        boolean result = level.m_46597_(pos, newState);
        if (Arrays.stream(Direction.values()).map(arg_0 -> ((BlockPos)pos).m_121945_(arg_0)).map(arg_0 -> ((Level)level).m_8055_(arg_0)).map(BlockBehaviour.BlockStateBase::m_60734_).anyMatch(block -> block instanceof IFluidBlock || block instanceof LiquidBlock)) {
            Block.m_49950_((BlockState)newState, (Level)level, (BlockPos)pos);
        }
        return result;
    }

    public boolean isFlexibleRail(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }
}

