/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.block;

import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrystalixGlass
extends AbstractGlassBlock
implements LiquidBlockContainer {
    public static final BooleanProperty SHADELESS = BooleanProperty.m_61465_((String)"shadeless");
    public static final BooleanProperty REINFORCED = BooleanProperty.m_61465_((String)"reinforced");
    public static final EnumProperty<BlockProperties.Light> LIGHT = EnumProperty.m_61587_((String)"light", BlockProperties.Light.class);
    public static final EnumProperty<BlockProperties.Ghost> GHOST = EnumProperty.m_61587_((String)"ghost", BlockProperties.Ghost.class);
    private final DyeColor color;

    public CrystalixGlass(DyeColor dyeColor) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50147_).m_284268_(dyeColor));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SHADELESS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)REINFORCED, (Comparable)Boolean.valueOf(false))).m_61124_(LIGHT, (Comparable)((Object)BlockProperties.Light.NONE))).m_61124_(GHOST, (Comparable)((Object)BlockProperties.Ghost.BLOCK_ALL)));
        this.color = dyeColor;
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        return this.color.m_41068_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHADELESS, REINFORCED, LIGHT, GHOST});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return this.m_49966_();
        }
        ItemStack offhand = player.m_21120_(InteractionHand.OFF_HAND);
        if (offhand.m_41720_() instanceof CrystalixWand) {
            BlockProperties properties = new BlockProperties(offhand);
            return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)SHADELESS, (Comparable)properties.shadeless.get())).m_61124_((Property)REINFORCED, (Comparable)properties.reinforced.get())).m_61124_(LIGHT, (Comparable)((Object)properties.light.get()))).m_61124_(GHOST, (Comparable)((Object)properties.ghost.get()));
        }
        return this.m_49966_();
    }

    public boolean canDropFromExplosion(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)REINFORCED) == false && super.canDropFromExplosion(state, level, pos, explosion);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        return (Boolean)state.m_61143_((Property)REINFORCED) == false && super.m_6864_(state, context);
    }

    public void onBlockExploded(BlockState state, Level level, BlockPos pos, Explosion explosion) {
        if (!((Boolean)state.m_61143_((Property)REINFORCED)).booleanValue()) {
            super.onBlockExploded(state, level, pos, explosion);
        }
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return (Boolean)state.m_61143_((Property)REINFORCED) == false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.m_61143_((Property)REINFORCED) != false ? Float.MAX_VALUE : super.getExplosionResistance(state, level, pos, explosion);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_61143_(LIGHT) != BlockProperties.Light.DARK;
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (state.m_61143_(LIGHT) == BlockProperties.Light.FAKE_LIGHT && level.m_46467_() % 4L == 0L) {
            level.m_5518_().m_7174_(pos);
            level.m_7260_(pos, state, state, 2);
        }
    }

    public int m_7753_(BlockState state, BlockGetter world, BlockPos pos) {
        return state.m_61143_(LIGHT) == BlockProperties.Light.DARK ? world.m_7469_() : 0;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        switch ((BlockProperties.Light)((Object)state.m_61143_(LIGHT))) {
            case FAKE_LIGHT: {
                if (world instanceof ServerLevel) break;
                return 15;
            }
            case LIGHT: {
                return 15;
            }
        }
        return 0;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        EntityCollisionContext entityCtx;
        if (context instanceof EntityCollisionContext && !(entityCtx = (EntityCollisionContext)context).equals(CollisionContext.m_82749_()) && ((BlockProperties.Ghost)((Object)state.m_61143_(GHOST))).canCollide(entityCtx)) {
            return Shapes.m_83040_();
        }
        return super.m_5939_(state, world, pos, context);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType pathType) {
        if (pathType == PathComputationType.LAND) {
            BlockProperties.Ghost ghost = (BlockProperties.Ghost)((Object)state.m_61143_(GHOST));
            return ghost != BlockProperties.Ghost.ALLOW_ALL && ghost != BlockProperties.Ghost.ALLOW_MONSTER && ghost != BlockProperties.Ghost.ALLOW_ANIMAL;
        }
        return false;
    }

    public boolean m_6044_(BlockGetter world, BlockPos pos, BlockState state, Fluid fluid) {
        return false;
    }

    public boolean m_7361_(LevelAccessor world, BlockPos pos, BlockState state, FluidState fluidState) {
        return false;
    }
}

