/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.item;

import com.satherov.crystalix.CrystalixConfig;
import com.satherov.crystalix.content.block.CrystalixGlass;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.IProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CrystalixWand
extends Item {
    public CrystalixWand(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public static void sendMessage(Player player, IProperty<?> property) {
        player.m_5661_(property.toComponent(), true);
    }

    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_();
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("shadeless", false);
        tag.m_128379_("reinforced", false);
        tag.m_128359_("light", BlockProperties.Light.NONE.m_7912_());
        tag.m_128359_("ghost", BlockProperties.Ghost.BLOCK_ALL.m_7912_());
        stack.m_41751_(tag);
        return stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> tooltipComponents, TooltipFlag pIsAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"crystalix.wand.bulk").m_130940_(ChatFormatting.GRAY));
        BlockProperties props = new BlockProperties(stack);
        Arrays.stream(props.properties).forEach(p -> tooltipComponents.add(p.toComponent()));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos;
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player != null && !level.f_46443_ && !this.applyToBlock((LevelAccessor)level, pos = context.m_8083_(), player)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public boolean applyToBlock(LevelAccessor accessor, BlockPos pos, Player player) {
        if (!(accessor.m_8055_(pos).m_60734_() instanceof CrystalixGlass)) {
            return false;
        }
        ItemStack wandStack = player.m_21205_();
        BlockProperties props = new BlockProperties(wandStack);
        Set<BlockPos> blocksToModify = player.m_6047_() ? this.getConnectedBlocks(accessor, pos, accessor.m_8055_(pos).m_60734_(), (Integer)CrystalixConfig.COMMON_CONFIG.maxWandEdit.get()) : Set.of(pos);
        for (BlockPos target : blocksToModify) {
            BlockState original = accessor.m_8055_(target);
            BlockState updated = (BlockState)((BlockState)((BlockState)((BlockState)original.m_61124_((Property)CrystalixGlass.SHADELESS, (Comparable)props.shadeless.get())).m_61124_((Property)CrystalixGlass.REINFORCED, (Comparable)props.reinforced.get())).m_61124_(CrystalixGlass.LIGHT, (Comparable)((Object)props.light.get()))).m_61124_(CrystalixGlass.GHOST, (Comparable)((Object)props.ghost.get()));
            accessor.m_7731_(target, updated, 3);
        }
        return true;
    }

    private Set<BlockPos> getConnectedBlocks(LevelAccessor accessor, BlockPos start, Object block, int limit) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty() && visited.size() < limit) {
            BlockPos current = (BlockPos)queue.poll();
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.m_121945_(dir);
                if (visited.contains(neighbor) || accessor.m_8055_(neighbor).m_60734_() != block) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return visited;
    }
}

