/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.content.properties;

import com.satherov.crystalix.content.properties.IProperty;
import java.util.Locale;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.jetbrains.annotations.Nullable;

public class BlockProperties {
    private static final String TAG_SHADELESS = "shadeless";
    private static final String TAG_REINFORCED = "reinforced";
    private static final String TAG_LIGHT = "light";
    private static final String TAG_GHOST = "ghost";
    public final IProperty<?>[] properties;
    public final IProperty<Boolean> shadeless;
    public final IProperty<Boolean> reinforced;
    public final IProperty<Light> light;
    public final IProperty<Ghost> ghost;
    private final CompoundTag wandTag;

    public BlockProperties(ItemStack wand) {
        this.wandTag = wand.m_41784_();
        this.shadeless = new NbtBooleanProperty(TAG_SHADELESS, false);
        this.reinforced = new NbtBooleanProperty(TAG_REINFORCED, false);
        this.light = new NbtEnumProperty(this, TAG_LIGHT, Light.class, (Enum)Light.NONE);
        this.ghost = new NbtEnumProperty(this, TAG_GHOST, Ghost.class, (Enum)Ghost.BLOCK_ALL);
        this.properties = new IProperty[]{this.shadeless, this.reinforced, this.light, this.ghost};
    }

    @Nullable
    public IProperty<?> get(String key) {
        for (IProperty<?> prop : this.properties) {
            if (!prop.getKey().equals(key)) continue;
            return prop;
        }
        return null;
    }

    private class NbtBooleanProperty
    implements IProperty<Boolean> {
        private final String key;
        private boolean value;

        NbtBooleanProperty(String key, boolean defaultValue) {
            this.key = key;
            if (BlockProperties.this.wandTag.m_128441_(key)) {
                this.value = BlockProperties.this.wandTag.m_128471_(key);
            } else {
                this.value = defaultValue;
                BlockProperties.this.wandTag.m_128379_(key, defaultValue);
            }
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValueString() {
            return this.value ? "enabled" : "disabled";
        }

        @Override
        public void setValueString(String val) {
            this.set("enabled".equals(val));
        }

        @Override
        public void set(Boolean val) {
            this.value = val;
            BlockProperties.this.wandTag.m_128379_(this.key, val.booleanValue());
        }

        @Override
        public Boolean get() {
            return this.value;
        }

        @Override
        public Boolean next(boolean forward) {
            boolean nextVal = !this.value;
            this.set(nextVal);
            return nextVal;
        }

        @Override
        public Component toComponent() {
            return Component.m_237115_((String)this.getKeyTranslation()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)this.getValueTranslation()).m_130940_(this.value ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED));
        }
    }

    private static class NbtEnumProperty<T extends Enum<T>>
    implements IProperty<T> {
        private final String key;
        private final Class<T> type;
        private final T defaultValue;
        private T value;
        final /* synthetic */ BlockProperties this$0;

        NbtEnumProperty(String key, Class<T> type, T defaultValue) {
            this.this$0 = var1_1;
            this.key = key;
            this.type = type;
            this.defaultValue = defaultValue;
            String stored = var1_1.wandTag.m_128441_(key) ? var1_1.wandTag.m_128461_(key) : ((StringRepresentable)defaultValue).m_7912_();
            this.value = this.findConstant(stored);
            var1_1.wandTag.m_128359_(key, ((StringRepresentable)this.value).m_7912_());
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValueString() {
            return ((StringRepresentable)this.value).m_7912_();
        }

        @Override
        public void setValueString(String val) {
            this.set(this.findConstant(val));
        }

        @Override
        public void set(T val) {
            this.value = val;
            this.this$0.wandTag.m_128359_(this.key, ((StringRepresentable)val).m_7912_());
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public T next(boolean forward) {
            Enum[] constants = (Enum[])this.type.getEnumConstants();
            int currentIndex = ((Enum)this.value).ordinal();
            int nextIndex = (currentIndex + (forward ? 1 : -1) + constants.length) % constants.length;
            Enum nextVal = constants[nextIndex];
            this.set((T)nextVal);
            return (T)nextVal;
        }

        @Override
        public Component toComponent() {
            return Component.m_237115_((String)this.getKeyTranslation()).m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)": ")).m_7220_((Component)Component.m_237115_((String)this.getValueTranslation()));
        }

        private T findConstant(String name) {
            for (Enum constant : (Enum[])this.type.getEnumConstants()) {
                if (!((StringRepresentable)constant).m_7912_().equals(name)) continue;
                return (T)constant;
            }
            return this.defaultValue;
        }
    }

    public static enum Light implements StringRepresentable
    {
        NONE(0),
        LIGHT(1),
        DARK(2),
        FAKE_LIGHT(3);

        public static final IntFunction<Light> BY_ID;
        private final int id;

        private Light(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            BY_ID = id -> switch (id) {
                case 1 -> LIGHT;
                case 2 -> DARK;
                case 3 -> FAKE_LIGHT;
                default -> NONE;
            };
        }
    }

    public static enum Ghost implements StringRepresentable
    {
        BLOCK_ALL(0, ctx -> false),
        ALLOW_ALL(1, ctx -> true),
        BLOCK_PLAYER(2, ctx -> !(ctx.m_193113_() instanceof Player)),
        ALLOW_PLAYER(3, ctx -> ctx.m_193113_() instanceof Player),
        BLOCK_MONSTER(4, ctx -> !(ctx.m_193113_() instanceof Monster)),
        ALLOW_MONSTER(5, ctx -> ctx.m_193113_() instanceof Monster),
        BLOCK_ANIMAL(6, ctx -> !(ctx.m_193113_() instanceof Animal)),
        ALLOW_ANIMAL(7, ctx -> ctx.m_193113_() instanceof Animal);

        public static final IntFunction<Ghost> BY_ID;
        private final int id;
        private final Predicate<EntityCollisionContext> collisionPredicate;

        private Ghost(int id, Predicate<EntityCollisionContext> collisionPredicate) {
            this.id = id;
            this.collisionPredicate = collisionPredicate;
        }

        public boolean canCollide(EntityCollisionContext ctx) {
            return this.collisionPredicate.test(ctx);
        }

        public int getId() {
            return this.id;
        }

        public String m_7912_() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            BY_ID = id -> switch (id) {
                case 1 -> ALLOW_ALL;
                case 2 -> BLOCK_PLAYER;
                case 3 -> ALLOW_PLAYER;
                case 4 -> BLOCK_MONSTER;
                case 5 -> ALLOW_MONSTER;
                case 6 -> BLOCK_ANIMAL;
                case 7 -> ALLOW_ANIMAL;
                default -> BLOCK_ALL;
            };
        }
    }
}

