/*
 * Decompiled with CFR 0.152.
 */
package com.satherov.crystalix.network;

import com.satherov.crystalix.content.CrystalixUtil;
import com.satherov.crystalix.content.item.CrystalixWand;
import com.satherov.crystalix.content.properties.BlockProperties;
import com.satherov.crystalix.content.properties.IProperty;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class CyclePropertyPayload {
    public final String key;
    public final String value;

    public CyclePropertyPayload(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static void encode(CyclePropertyPayload msg, FriendlyByteBuf buf) {
        buf.m_130070_(msg.key);
        buf.m_130070_(msg.value);
    }

    public static CyclePropertyPayload decode(FriendlyByteBuf buf) {
        String key = buf.m_130136_(100);
        String value = buf.m_130136_(100);
        return new CyclePropertyPayload(key, value);
    }

    public static class Handler {
        public static void handle(CyclePropertyPayload msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                ServerPlayer player = ctx.getSender();
                if (player == null) {
                    return;
                }
                ItemStack wand = CrystalixUtil.getWand((Player)player);
                if (wand.m_41619_()) {
                    return;
                }
                BlockProperties props = new BlockProperties(wand);
                IProperty<?> property = props.get(msg.key);
                if (property == null) {
                    return;
                }
                property.setValueString(msg.value);
                CrystalixWand.sendMessage((Player)player, property);
                player.m_150109_().m_6596_();
            });
            ctx.setPacketHandled(true);
        }
    }
}

