/*
 * Decompiled with CFR 0.152.
 */
package website.eccentric.tome;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import website.eccentric.tome.Configuration;
import website.eccentric.tome.EccentricTome;
import website.eccentric.tome.ModName;
import website.eccentric.tome.Tome;
import website.eccentric.tome.TomeItem;

public class AttachmentRecipe
extends CustomRecipe {
    public AttachmentRecipe(ResourceLocation location, CraftingBookCategory category) {
        super(location, category);
    }

    public boolean matches(CraftingContainer crafting, Level level) {
        boolean foundTome = false;
        boolean foundTarget = false;
        for (int i = 0; i < crafting.m_6643_(); ++i) {
            ItemStack stack = crafting.m_8020_(i);
            if (stack.m_41619_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof BlockItem) {
                return false;
            }
            if (item instanceof TomeItem) {
                if (foundTome) {
                    return false;
                }
                foundTome = true;
                continue;
            }
            if (this.isTarget(stack)) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            return false;
        }
        return foundTome && foundTarget;
    }

    public ItemStack assemble(CraftingContainer crafting, RegistryAccess access) {
        ItemStack tome = ItemStack.f_41583_;
        ItemStack target = ItemStack.f_41583_;
        for (int i = 0; i < crafting.m_6643_(); ++i) {
            ItemStack stack = crafting.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof TomeItem) {
                tome = stack.m_41777_();
                continue;
            }
            target = stack.m_41777_();
        }
        tome = Tome.attach(tome, target);
        return tome;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public boolean isTarget(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        String mod = ModName.from(stack);
        if (((Boolean)Configuration.ALL_ITEMS.get()).booleanValue()) {
            return true;
        }
        if (((List)Configuration.EXCLUDE.get()).contains(mod)) {
            return false;
        }
        ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        String locationString = location.toString();
        String locationDamage = locationString + ":" + stack.m_41773_();
        List excludeItems = (List)Configuration.EXCLUDE_ITEMS.get();
        if (excludeItems.contains(locationString) || excludeItems.contains(locationDamage)) {
            return false;
        }
        List items = (List)Configuration.ITEMS.get();
        if (items.contains(locationString) || items.contains(locationDamage)) {
            return true;
        }
        for (String tag : (List)Configuration.INCLUDE_ITEM_TAGS.get()) {
            ITag itemTag = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation(tag)));
            if (!itemTag.contains((Object)stack.m_41720_())) continue;
            return true;
        }
        String path = location.m_135815_();
        for (String name : (List)Configuration.NAMES.get()) {
            if (!path.contains(name)) continue;
            return true;
        }
        return false;
    }

    public ItemStack m_8043_(RegistryAccess access) {
        return ItemStack.f_41583_;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer crafting) {
        return NonNullList.m_122780_((int)crafting.m_6643_(), (Object)ItemStack.f_41583_);
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EccentricTome.ATTACHMENT.get();
    }
}

