/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.common.entity;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractSpell
extends Entity
implements TraceableEntity {
    @Nullable
    protected Entity owner;
    @Nullable
    protected UUID ownerUUID;
    public float power;

    public AbstractSpell(EntityType<? extends AbstractSpell> type, Level level) {
        super(type, level);
        this.f_19794_ = true;
    }

    public AbstractSpell(EntityType<? extends AbstractSpell> type, Level level, Vec3 pos, @Nullable Entity owner, float power) {
        this(type, level);
        this.f_19794_ = true;
        this.m_20219_(pos);
        if (owner != null) {
            this.owner = owner;
            this.ownerUUID = owner.m_20148_();
        }
        this.power = power;
    }

    public SoundSource m_5720_() {
        Entity owner = this.m_19749_();
        return owner == null ? SoundSource.NEUTRAL : owner.m_5720_();
    }

    public void m_8119_() {
        if (this.f_19803_) {
            this.onCast();
            this.f_19803_ = false;
        }
        if (!this.f_19853_.m_5776_() && this.f_19797_ > this.getDuration()) {
            this.onExpire();
            this.m_146870_();
        } else {
            this.activeTick();
        }
    }

    protected abstract int getDuration();

    protected float getPower() {
        return this.power;
    }

    protected void onCast() {
    }

    protected void activeTick() {
    }

    protected void onExpire() {
    }

    public Entity m_19749_() {
        ServerLevel serverLevel;
        Level level;
        if (this.owner != null && !this.owner.m_213877_()) {
            return this.owner;
        }
        if (this.ownerUUID != null && (level = this.f_19853_) instanceof ServerLevel && (level = (serverLevel = (ServerLevel)level).m_8791_(this.ownerUUID)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)level;
            this.owner = living;
            return this.owner;
        }
        return null;
    }

    public boolean m_5825_() {
        return true;
    }

    protected void m_8097_() {
    }

    protected void m_7380_(CompoundTag tag) {
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128350_("Power", this.power);
        tag.m_128405_("Age", this.f_19797_);
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
        }
        this.power = tag.m_128457_("Power");
        this.f_19797_ = tag.m_128451_("Age");
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean m_6783_(double distSqr) {
        double d0 = 64.0 * AbstractSpell.m_20150_();
        return distSqr < d0 * d0;
    }
}

