/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.capability;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.inventory.BackpackWrapper;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.network.ClientboundSyncComponentsPacket;
import com.tiviacz.travelersbackpack.util.PacketDistributorHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.UnknownNullability;

public class TravelersBackpackWearable
implements ITravelersBackpack,
INBTSerializable<CompoundTag> {
    public final Player player;
    public BackpackWrapper backpackWrapper;
    public ItemStack backpack = new ItemStack((ItemLike)Items.f_41852_, 0);

    public TravelersBackpackWearable(Player player) {
        this.player = player;
    }

    @Override
    public boolean hasBackpack() {
        return this.backpack.m_41720_() instanceof TravelersBackpackItem;
    }

    @Override
    public ItemStack getBackpack() {
        return this.backpack;
    }

    @Override
    public void equipBackpack(ItemStack stack) {
        this.remove();
        if (!(stack.m_41720_() instanceof TravelersBackpackItem)) {
            return;
        }
        this.backpack = stack;
        this.backpackWrapper = new BackpackWrapper(this.backpack, 2, this.player, this.player.m_9236_());
        this.backpackWrapper.setBackpackOwner(this.player);
        this.synchronise();
    }

    @Override
    public void updateBackpack(ItemStack stack) {
        if (this.backpackWrapper != null) {
            this.backpack = stack;
            this.backpackWrapper.setBackpackStack(this.backpack);
        } else {
            this.equipBackpack(stack);
        }
    }

    @Override
    public void applyComponents(CompoundTag compound) {
        if (this.backpackWrapper != null) {
            for (String key : compound.m_128431_()) {
                this.backpack.m_41784_().m_128365_(key, compound.m_128423_(key));
            }
            this.backpackWrapper.setBackpackStack(this.backpack);
        }
    }

    @Override
    public void removeWearable() {
        this.backpack = new ItemStack((ItemLike)Items.f_41852_, 0);
    }

    @Override
    public void removeWrapper() {
        if (this.backpackWrapper != null) {
            this.backpackWrapper = null;
        }
    }

    @Override
    public void remove() {
        this.removeWearable();
        this.removeWrapper();
        if (this.player.m_9236_() != null && !this.player.m_9236_().f_46443_) {
            PacketDistributorHelper.sendToPlayersTrackingEntityAndSelf((ServerPlayer)this.player, new ClientboundSyncCapabilityPacket(this.player.m_19879_(), this.backpack, true));
        }
    }

    @Override
    public BackpackWrapper getWrapper() {
        return this.backpackWrapper;
    }

    @Override
    public void synchronise() {
        if (this.player != null && !this.player.m_9236_().f_46443_) {
            CapabilityUtils.getCapability(this.player).ifPresent(cap -> PacketDistributorHelper.sendToPlayersTrackingEntityAndSelf((ServerPlayer)this.player, new ClientboundSyncCapabilityPacket(this.player.m_19879_(), this.backpack)));
        }
    }

    @Override
    public void synchronise(CompoundTag compound) {
        if (this.player != null && !this.player.m_9236_().f_46443_) {
            CapabilityUtils.getCapability(this.player).ifPresent(cap -> PacketDistributorHelper.sendToPlayersTrackingEntityAndSelf((ServerPlayer)this.player, new ClientboundSyncComponentsPacket(this.player.m_19879_(), compound)));
        }
    }

    @Override
    public @UnknownNullability CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        if (this.hasBackpack()) {
            ItemStack backpack = this.getBackpack();
            compound = backpack.m_41739_(new CompoundTag());
        }
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ItemStack backpack = ItemStack.m_41712_((CompoundTag)nbt);
        this.equipBackpack(backpack);
    }
}

