/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.modules.lib;

import com.brandon3055.draconicevolution.api.modules.Module;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;

public class InstallResult {
    public final InstallResultType resultType;
    public final Module<?> module;
    public final Module<?> incompatibleModule;
    public final List<Component> reason;

    public InstallResult(InstallResultType resultType, Module<?> module, Module<?> incompatibleModule, List<Component> reason) {
        this.resultType = resultType;
        this.module = module;
        this.incompatibleModule = incompatibleModule;
        this.reason = reason;
    }

    public InstallResult(InstallResultType resultType, Module<?> module, Module<?> incompatibleModule, Component reason) {
        this(resultType, module, incompatibleModule, Collections.singletonList(reason));
    }

    public InstallResult getBlockingResult(InstallResult other) {
        switch (this.resultType) {
            case YES: {
                if (other.resultType == InstallResultType.YES) {
                    return this;
                }
                if (other.resultType == InstallResultType.ONLY_WHEN_OVERRIDEN) {
                    return other;
                }
            }
            case ONLY_WHEN_OVERRIDEN: {
                if (other.resultType == InstallResultType.OVERRIDE) {
                    return other;
                }
            }
            case OVERRIDE: {
                if (other.resultType == InstallResultType.ONLY_WHEN_OVERRIDEN || other.resultType == InstallResultType.YES) {
                    return this;
                }
            }
            default: {
                if (other.resultType != InstallResultType.NO) break;
                return other;
            }
            case NO: 
        }
        return this;
    }

    public static enum InstallResultType {
        YES,
        ONLY_WHEN_OVERRIDEN,
        OVERRIDE,
        NO;

    }
}

