/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity.chest;

import codechicken.lib.math.MathHelper;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.api.power.OPStorage;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.capability.CapabilityOP;
import com.brandon3055.brandonscore.inventory.TileItemStackHandler;
import com.brandon3055.brandonscore.lib.IInteractTile;
import com.brandon3055.brandonscore.lib.IRSSwitchable;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.draconicevolution.api.modules.lib.ModularOPStorage;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.blocks.tileentity.chest.SmeltingLogic;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.DraconiumChestMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.network.NetworkHooks;

public class TileDraconiumChest
extends TileBCore
implements IRSSwitchable,
MenuProvider,
IInteractTile {
    public final ManagedInt colour = (ManagedInt)this.register((IManagedData)new ManagedInt("colour", 6553750, new DataFlags[]{DataFlags.SAVE_BOTH_SYNC_TILE, DataFlags.CLIENT_CONTROL}));
    public final ManagedShort numPlayersUsing = (ManagedShort)this.register((IManagedData)new ManagedShort("num_players_using", new DataFlags[]{DataFlags.SYNC_TILE}));
    public float prevLidAngle;
    public float lidAngle;
    public TileItemStackHandler mainInventory = new TileItemStackHandler((BlockEntity)this, 260);
    public TileItemStackHandler craftingItems = new TileItemStackHandler((BlockEntity)this, 9);
    public TileItemStackHandler furnaceItems = new TileItemStackHandler((BlockEntity)this, 5);
    public TileItemStackHandler capacitorInv = new TileItemStackHandler((BlockEntity)this, 1);
    public OPStorage opStorage = new ModularOPStorage(this, 1000000L, 128000L, 0L);
    public SmeltingLogic smeltingLogic = new SmeltingLogic(this, (IItemHandlerModifiable)this.furnaceItems, (IItemHandler)this.mainInventory, this.opStorage);

    public TileDraconiumChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)DEContent.TILE_DRACONIUM_CHEST.get(), pos, state);
        this.capManager.setManaged("energy", CapabilityOP.OP, (INBTSerializable)this.opStorage, new Direction[0]).saveBoth().syncContainer();
        this.capManager.setManaged("main_inv", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.mainInventory, new Direction[0]).saveBoth();
        this.capManager.setInternalManaged("crafting_inv", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.craftingItems).saveBoth();
        this.capManager.setInternalManaged("furnace_inv", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.furnaceItems).saveBoth();
        this.capManager.setInternalManaged("energy_inv", ForgeCapabilities.ITEM_HANDLER, (INBTSerializable)this.capacitorInv).saveBoth();
        this.furnaceItems.setStackValidator(stack -> this.smeltingLogic.isSmeltable((ItemStack)stack));
        this.furnaceItems.setContentsChangeListener(e -> this.smeltingLogic.inputInventoryChanged());
        this.mainInventory.setContentsChangeListener(e -> this.smeltingLogic.outputInventoryChanged().scheduleAutoFeed());
        this.mainInventory.setStackValidator(DraconiumChest::isStackValid);
        this.capacitorInv.setStackValidator(EnergyUtils::isEnergyItem);
        this.smeltingLogic.setFeedSourceInv((IItemHandlerModifiable)this.mainInventory);
        this.installIOTracker(this.opStorage);
    }

    public void tick() {
        assert (this.f_58857_ != null);
        super.tick();
        if (!this.f_58857_.m_5776_()) {
            this.numPlayersUsing.set((short)this.getAccessingPlayers().size());
            boolean enabled = this.isTileEnabled();
            if (enabled && this.opStorage.getOPStored() < this.opStorage.getMaxOPStored() && !this.capacitorInv.getStackInSlot(0).m_41619_()) {
                EnergyUtils.transferEnergy((ItemStack)this.capacitorInv.getStackInSlot(0), (IOPStorage)this.opStorage);
            }
            this.smeltingLogic.tick(enabled);
        }
        this.prevLidAngle = this.lidAngle;
        this.lidAngle = (float)MathHelper.approachLinear((double)this.lidAngle, (double)(this.numPlayersUsing.get() > 0 ? 1.0 : 0.0), (double)0.1);
        if ((double)this.prevLidAngle >= 0.5 && (double)this.lidAngle < 0.5) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        } else if (this.prevLidAngle == 0.0f && this.lidAngle > 0.0f) {
            this.f_58857_.m_5594_(null, this.m_58899_(), SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
    }

    public InteractionResult onBlockUse(BlockState state, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)this.f_58858_);
        }
        return InteractionResult.SUCCESS;
    }

    public AbstractContainerMenu m_7208_(int currentWindowIndex, Inventory playerInventory, Player player) {
        return new DraconiumChestMenu((MenuType)DEContent.MENU_DRACONIUM_CHEST.get(), currentWindowIndex, playerInventory, this);
    }

    public void writeExtraTileAndStack(CompoundTag compound) {
        this.smeltingLogic.saveAdditionalNBT(compound);
        compound.m_128379_("inv_migrated", true);
    }

    public void readExtraTileAndStack(CompoundTag compound) {
        this.smeltingLogic.loadAdditionalNBT(compound);
    }
}

