/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.command;

import com.brandon3055.brandonscore.worldentity.WorldEntity;
import com.brandon3055.brandonscore.worldentity.WorldEntityHandler;
import com.brandon3055.draconicevolution.blocks.tileentity.TileChaosCrystal;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class CommandRespawnGuardian {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"respawn_draconic_guardian").requires(cs -> cs.m_6761_(2))).executes(context -> CommandRespawnGuardian.respawn((CommandContext<CommandSourceStack>)context, false)));
    }

    private static int respawn(CommandContext<CommandSourceStack> ctx, boolean spawnHere) throws CommandSyntaxException {
        if (spawnHere) {
            return CommandRespawnGuardian.spawnHere(ctx);
        }
        Vec3 pos = ((CommandSourceStack)ctx.getSource()).m_81371_();
        TileChaosCrystal tile = BlockPos.m_121990_((BlockPos)BlockPos.m_274446_((Position)pos).m_7918_(-60, -60, -60), (BlockPos)BlockPos.m_274446_((Position)pos).m_7918_(60, 60, 60)).filter(e -> ((CommandSourceStack)ctx.getSource()).m_81372_().m_7702_(e) instanceof TileChaosCrystal).map(e -> (TileChaosCrystal)((CommandSourceStack)ctx.getSource()).m_81372_().m_7702_(e)).findAny().orElse(null);
        if (tile == null) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"Chaos crystal not detected! Please run this command within 60 blocks of an islands chaos crystal."));
        }
        if (tile.parentPos.notNull()) {
            BlockEntity parent = tile.m_58904_().m_7702_(tile.parentPos.get());
            if (parent instanceof TileChaosCrystal) {
                tile = (TileChaosCrystal)parent;
            } else {
                throw new CommandRuntimeException((Component)Component.m_237113_((String)"Found invalid chaos crystal at this location"));
            }
        }
        TileChaosCrystal finalTile = tile;
        GuardianFightManager existingFight = WorldEntityHandler.getWorldEntities().stream().filter(e -> e instanceof GuardianFightManager).map(e -> (GuardianFightManager)((Object)e)).filter(e -> e.getArenaOrigin().equals((Object)finalTile.m_58899_())).findAny().orElse(null);
        if (existingFight != null) {
            throw new CommandRuntimeException((Component)Component.m_237113_((String)"There should already be a guardian in this area"));
        }
        tile.guardianDefeated.set(false);
        WorldEntityHandler.addWorldEntity((Level)tile.m_58904_(), (WorldEntity)new GuardianFightManager(tile.m_58899_()));
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Reset Successful. Go to center of island to trigger spawning sequence.").m_130940_(ChatFormatting.GREEN), true);
        return 0;
    }

    private static int spawnHere(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        return 0;
    }
}

