/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.particle.GuardianChargeParticle;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.handlers.DESounds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class ChargeUpPhase
extends Phase {
    protected Map<Player, Vec3> trappedPlayers = new HashMap<Player, Vec3>();
    protected int requiredChargeTime;
    protected int chargeTime;
    protected int chargedTime;
    private int effectTimer = 0;
    private int effectTime = 0;
    public boolean disableFlight = false;
    public boolean trapPlayers = false;
    float speedMod;
    int offGroundTime = 0;

    public ChargeUpPhase(DraconicGuardianEntity guardian, int requiredChargeTime) {
        super(guardian);
        this.requiredChargeTime = requiredChargeTime;
    }

    @Override
    public boolean getIsStationary() {
        return true;
    }

    @Override
    public void initPhase() {
        this.chargeTime = 0;
        this.chargedTime = 0;
        this.effectTimer = 0;
    }

    @Override
    public void removeAreaEffect() {
        this.trappedPlayers.clear();
    }

    public void resetCharge() {
        this.chargeTime = 0;
    }

    @Override
    public void serverTick() {
        GuardianFightManager manager;
        BlockPos origin;
        GuardianFightManager manager2;
        if (this.trappedPlayers == null) {
            this.trappedPlayers = new HashMap<Player, Vec3>();
        }
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        if (this.trapPlayers && this.isCharged() && (manager2 = this.guardian.getFightManager()) != null) {
            for (Player player : manager2.getTrackedPlayers()) {
                Vec3 vec3 = player.m_20182_();
                Vec3 lastPos = this.trappedPlayers.getOrDefault(player, player.m_20182_());
                Vec3 center = Vec3.m_82512_((Vec3i)manager2.getArenaOrigin().m_7918_(0, 16, 0));
                double currentDist = vec3.m_82557_(center);
                int threshold = 10000;
                int breakAway = 1000000;
                if (currentDist > (double)threshold && currentDist < (double)breakAway && lastPos.m_82557_(center) <= (double)threshold && player.m_9236_().m_46472_().equals(this.guardian.m_9236_().m_46472_())) {
                    TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.m_9236_().m_46472_(), (double)lastPos.f_82479_, (double)lastPos.f_82480_, (double)lastPos.f_82481_);
                }
                if (this.isValidTarget((LivingEntity)player) && player.m_20186_() < (double)(manager2.getArenaOrigin().m_123342_() - 10)) {
                    TeleportUtils.teleportEntity((Entity)player, (ResourceKey)player.m_9236_().m_46472_(), (double)player.m_20185_(), (double)(manager2.getArenaOrigin().m_123342_() + 15), (double)player.m_20189_());
                }
                if (!(player.m_20182_().m_82557_(center) < (double)threshold)) continue;
                this.trappedPlayers.put(player, player.m_20182_());
            }
        }
        if ((origin = this.guardian.getArenaOrigin()) == null) {
            return;
        }
        if (this.disableFlight && this.getChargeProgress() > 0.5 && (manager = this.guardian.getFightManager()) != null) {
            for (Player player : manager.getTrackedPlayers()) {
                if (!(player.m_20186_() > (double)(origin.m_123342_() + 8)) || !player.m_150110_().f_35935_) continue;
                player.m_150110_().f_35935_ = false;
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        double z;
        int i;
        if (this.chargeTime < this.requiredChargeTime) {
            ++this.chargeTime;
        } else {
            ++this.chargedTime;
        }
        BlockPos origin = this.guardian.getArenaOrigin();
        if (origin == null) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || !this.isValidTarget((LivingEntity)player)) {
            return;
        }
        if (this.effectTimer == 0) {
            this.speedMod = (float)this.getChargeProgress();
            this.effectTime = this.effectTimer = (int)(20.0f - this.speedMod * 10.0f);
            this.guardian.m_9236_().m_7785_(this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_(), (SoundEvent)DESounds.CRYSTAL_BEAM.get(), SoundSource.HOSTILE, 64.0f, 1.0f + this.speedMod, false);
            if (origin != null) {
                for (i = 0; i < 32; ++i) {
                    Minecraft.m_91087_().f_91061_.m_107344_((Particle)new GuardianChargeParticle((ClientLevel)this.guardian.m_9236_(), Vector3.fromBlockPosCenter((BlockPos)origin), Vector3.fromEntity((Entity)this.guardian), (double)i / 32.0, this.effectTime, this.guardian.getPhaseManager()));
                }
            }
        } else {
            --this.effectTimer;
        }
        if (this.trapPlayers) {
            for (i = 0; i < 4; ++i) {
                float randDir = this.random.m_188501_() * (float)Math.PI * 2.0f;
                int randDist = 95 + this.random.m_188503_(30);
                double x = this.guardian.m_20185_() + (double)(Mth.m_14031_((float)randDir) * (float)randDist);
                z = this.guardian.m_20189_() + (double)(Mth.m_14089_((float)randDir) * (float)randDist);
                double y = this.guardian.m_20186_() - 8.0 - (double)this.random.m_188503_(32);
                Vector3 motion = new Vector3(this.guardian.m_20185_(), y, this.guardian.m_20189_()).subtract(x, y, z).normalize().multiply((1.0 + this.random.m_188500_()) * this.getChargeProgress());
                this.guardian.m_9236_().m_6493_((ParticleOptions)DEParticles.GUARDIAN_CLOUD.get(), true, x, y, z, motion.x, motion.y, motion.z);
            }
            Vector3 center = new Vector3(this.guardian.m_20185_(), this.guardian.m_20186_() - 32.0, this.guardian.m_20189_());
            int threshold = 85;
            if (!player.m_150110_().f_35937_) {
                if (player.m_20238_(center.vec3()) > (double)(threshold * threshold)) {
                    double distanceOver = Math.sqrt(player.m_20238_(center.vec3())) - (double)threshold;
                    Vector3 forceVec = center.copy().subtract(player.m_20185_(), player.m_20186_(), player.m_20189_()).normalize().multiply(1.0 * (distanceOver / 10.0) * this.getChargeProgress());
                    this.debug(forceVec.toString());
                    player.m_20256_(player.m_20184_().m_82549_(forceVec.vec3()));
                }
                if (player.m_20186_() < (double)origin.m_123342_()) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, ((double)origin.m_123342_() - player.m_20186_()) / 5.0 * this.getChargeProgress(), 0.0));
                }
            }
        }
        if (this.disableFlight && player != null && !player.m_150110_().f_35937_ && this.getChargeProgress() > 0.5) {
            if (player.m_20186_() > (double)(origin.m_123342_() + 8)) {
                if (player.m_150110_().f_35935_) {
                    player.m_150110_().f_35935_ = false;
                }
                if (player.m_21255_()) {
                    Vec3 motion = player.m_20184_();
                    player.m_20334_(motion.f_82479_ * 0.75, motion.f_82480_ > 0.0 ? motion.f_82480_ * 0.75 : motion.f_82480_, motion.f_82481_ * 0.75);
                }
            }
            if (player.m_20096_() || player.m_20186_() < (double)(origin.m_123342_() + 8)) {
                this.offGroundTime = 0;
            } else {
                ++this.offGroundTime;
                if (this.offGroundTime > 40) {
                    player.m_20256_(player.m_20184_().m_82520_(0.0, (double)Math.min(this.offGroundTime - 40, 200) / -100.0, 0.0));
                }
            }
            for (i = 0; i < 2; ++i) {
                double y;
                double x = this.guardian.m_20185_() - 95.0 + (double)this.random.m_188503_(190);
                if (!(this.guardian.m_20275_(x, y = this.guardian.m_20186_() - (double)this.random.m_188503_(35), z = this.guardian.m_20189_() - 95.0 + (double)this.random.m_188503_(190)) < 10000.0)) continue;
                this.guardian.m_9236_().m_6493_((ParticleOptions)DEParticles.GUARDIAN_CLOUD.get(), true, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public float animState() {
        return this.effectTimer > 0 ? (float)this.effectTimer / (float)this.effectTime : 0.0f;
    }

    public double getChargeProgress() {
        return (double)this.chargeTime / (double)this.requiredChargeTime;
    }

    public boolean isCharged() {
        return this.chargeTime >= this.requiredChargeTime;
    }

    @Override
    public float onAttacked(DamageSource source, float damage, float shield, boolean effective) {
        if (this.isInvulnerable()) {
            if (source.m_7640_() instanceof AbstractArrow) {
                source.m_7640_().m_20254_(1);
            }
            return 0.0f;
        }
        return super.onAttacked(source, damage, shield, effective);
    }

    @Override
    public void handlePacket(MCDataInput input, int func) {
        if (func == 0) {
            this.resetCharge();
        }
    }

    @Override
    public boolean isInvulnerable() {
        return true;
    }
}

