/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import com.brandon3055.brandonscore.inventory.PlayerSlot;
import com.brandon3055.brandonscore.inventory.SlotCheckValid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ContainerJunkFilter
extends AbstractContainerMenu {
    private final ItemStack stack;
    private final Player player;
    private final PlayerSlot slot;
    private final IItemHandler itemHandler;

    public ContainerJunkFilter(@Nullable MenuType<?> type, int id, Player player, PlayerSlot slot, IItemHandler itemHandler) {
        super(type, id);
        this.player = player;
        this.slot = slot;
        this.itemHandler = itemHandler;
        this.stack = slot.getStackInSlot(player);
        this.addPlayerSlots(8, 29 + itemHandler.getSlots() / 9 * 18, 4);
        this.addJunkSlots(8, 21);
    }

    public void m_38946_() {
        if (this.stack != this.slot.getStackInSlot(this.player) && !this.player.m_9236_().f_46443_) {
            this.player.m_6915_();
        }
        super.m_38946_();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (slotId >= 0 && slotId < this.f_38839_.size() && ((Slot)this.f_38839_.get(slotId)).m_7993_() == this.stack) {
            return;
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    @Nullable
    public ItemStack m_7648_(Player playerIn, int i) {
        Slot slot = this.m_38853_(i);
        if (slot != null && slot.m_6657_()) {
            ItemStack stack = slot.m_7993_();
            ItemStack result = stack.m_41777_();
            if (i >= 36 ? !this.m_38903_(stack, 0, 36, false) : !this.m_38903_(stack, 36, 36 + this.itemHandler.getSlots(), false)) {
                return ItemStack.f_41583_;
            }
            if (stack.m_41613_() == 0) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            slot.m_142406_(this.player, stack);
            return result;
        }
        return ItemStack.f_41583_;
    }

    public void m_182406_(int slotID, int stateId, ItemStack stack) {
        Slot slot = this.m_38853_(slotID);
        if (slot != null) {
            slot.m_5852_(stack);
        }
        this.f_182405_ = stateId;
    }

    public Slot m_38853_(int slotId) {
        if (slotId < this.f_38839_.size() && slotId >= 0) {
            return (Slot)this.f_38839_.get(slotId);
        }
        return null;
    }

    public void m_182410_(int stateId, List<ItemStack> stacks, ItemStack carried) {
        for (int i = 0; i < stacks.size(); ++i) {
            Slot slot = this.m_38853_(i);
            if (slot == null) continue;
            slot.m_5852_(stacks.get(i));
        }
        this.f_150393_ = carried;
        this.f_182405_ = stateId;
    }

    public void addPlayerSlots(int posX, int posY, int hotbarSpacing) {
        for (int x = 0; x < 9; ++x) {
            this.m_38897_((Slot)new SlotCheckValid.IInv((Container)this.player.m_150109_(), x, posX + 18 * x, posY + 54 + hotbarSpacing));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_((Slot)new SlotCheckValid.IInv((Container)this.player.m_150109_(), x + y * 9 + 9, posX + 18 * x, posY + y * 18));
            }
        }
    }

    public void addJunkSlots(int posX, int posY) {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            int x = i % 9 * 18;
            int y = i / 9 * 18;
            this.m_38897_((Slot)new SlotItemHandler(this.itemHandler, i, posX + x, posY + y));
        }
    }
}

