/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class MobSoul
extends ItemBCore {
    private static Map<String, Entity> renderEntityMap = new HashMap<String, Entity>();
    private static Map<String, String> entityNameCache = new HashMap<String, String>();
    public static List<String> randomDisplayList = null;
    private static Map<String, ResourceLocation> rlCache = new WeakHashMap<String, ResourceLocation>();

    public MobSoul(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        Direction facing = context.m_43719_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        ItemStack stack = player.m_21120_(context.m_43724_());
        if (player.m_6144_()) {
            Entity entity = this.createEntity(world, stack);
            double sX = (double)(pos.m_123341_() + facing.m_122429_()) + 0.5;
            double sY = (double)(pos.m_123342_() + facing.m_122430_()) + 0.5;
            double sZ = (double)(pos.m_123343_() + facing.m_122431_()) + 0.5;
            if (entity == null) {
                LogHelper.error("Mob Soul bound entity = null");
                return super.m_6225_(context);
            }
            entity.m_7678_(sX, sY, sZ, player.m_146908_(), 0.0f);
            if (!world.f_46443_) {
                CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)stack);
                if (!compound.m_128441_("EntityData") && entity instanceof Mob) {
                    ((Mob)entity).m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(new BlockPos(0, 0, 0)), MobSpawnType.SPAWN_EGG, null, null);
                }
                world.m_7967_(entity);
                if (!player.m_150110_().f_35937_) {
                    InventoryUtils.consumeHeldItem((Player)player, (ItemStack)stack, (InteractionHand)context.m_43724_());
                }
            }
        }
        return super.m_6225_(context);
    }

    public Component m_7626_(ItemStack stack) {
        String eName = this.getEntityString(stack);
        EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MobSoul.getCachedRegName(eName));
        if (type == null) {
            return super.m_7626_(stack);
        }
        return Component.m_237115_((String)type.m_20675_()).m_130946_(" ").m_7220_(super.m_7626_(stack));
    }

    public String getEntityString(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"EntityName", (String)"pig");
    }

    public void setEntity(ResourceLocation entityName, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"EntityName", (String)String.valueOf(entityName));
    }

    @Nullable
    public CompoundTag getEntityData(ItemStack stack) {
        CompoundTag compound = ItemNBTHelper.getCompound((ItemStack)stack);
        if (compound.m_128441_("EntityData")) {
            return compound.m_128469_("EntityData");
        }
        return null;
    }

    public void setEntityData(CompoundTag compound, ItemStack stack) {
        compound.m_128473_("UUID");
        compound.m_128473_("Motion");
        ItemNBTHelper.getCompound((ItemStack)stack).m_128365_("EntityData", (Tag)compound);
    }

    public Entity createEntity(Level world, ItemStack stack) {
        try {
            Entity entity;
            String eName = this.getEntityString(stack);
            CompoundTag entityData = this.getEntityData(stack);
            EntityType type = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MobSoul.getCachedRegName(eName));
            if (type == null) {
                entity = EntityType.f_20510_.m_20615_(world);
            } else {
                entity = type.m_20615_(world);
                if (entity == null) {
                    return EntityType.f_20510_.m_20615_(world);
                }
                if (entityData != null) {
                    entity.m_20258_(entityData);
                } else if (entity instanceof Mob) {
                    ((Mob)entity).m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(new BlockPos(0, 0, 0)), MobSpawnType.SPAWN_EGG, null, null);
                }
            }
            return entity;
        }
        catch (Throwable e) {
            return EntityType.f_20510_.m_20615_(world);
        }
    }

    public ItemStack getSoulFromEntity(Entity entity, boolean saveEntityData) {
        ItemStack soul = new ItemStack((ItemLike)DEContent.MOB_SOUL.get());
        String registryName = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString();
        ItemNBTHelper.setString((ItemStack)soul, (String)"EntityName", (String)registryName);
        if (saveEntityData) {
            CompoundTag compound = new CompoundTag();
            entity.m_20240_(compound);
            this.setEntityData(compound, soul);
        }
        return soul;
    }

    public Entity getRenderEntity(ItemStack stack) {
        return this.getRenderEntity(this.getEntityString(stack));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Entity getRenderEntity(String name) {
        if (name.equals("[Random-Display]")) {
            if (randomDisplayList == null) {
                randomDisplayList = new ArrayList<String>();
                SpawnEggItem.f_43201_.keySet().forEach(type -> randomDisplayList.add(ForgeRegistries.ENTITY_TYPES.getKey(type).toString()));
            }
            if (randomDisplayList.size() > 0) {
                name = randomDisplayList.get(ClientEventHandler.elapsedTicks / 20 % randomDisplayList.size());
            }
        }
        if (!renderEntityMap.containsKey(name)) {
            Entity entity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            try {
                EntityType type2 = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(MobSoul.getCachedRegName(name));
                if (type2 != null) {
                    entity = type2.m_20615_((Level)level);
                    if (entity == null) {
                        entity = EntityType.f_20510_.m_20615_((Level)level);
                    }
                } else {
                    entity = EntityType.f_20510_.m_20615_((Level)level);
                }
            }
            catch (Throwable e) {
                entity = EntityType.f_20510_.m_20615_((Level)level);
            }
            renderEntityMap.put(name, entity);
        }
        return renderEntityMap.get(name);
    }

    public static ResourceLocation getCachedRegName(String name) {
        return rlCache.computeIfAbsent(name, ResourceLocation::new);
    }
}

