/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.packet;

import java.util.function.Supplier;
import net.gigabit101.rebornstorage.blockentities.BlockEntityMultiCrafter;
import net.gigabit101.rebornstorage.packet.PacketHandler;
import net.gigabit101.rebornstorage.packet.PacketMultiblockUpdate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRequestMultiblockUpdate {
    private final BlockPos blockPos;

    public PacketRequestMultiblockUpdate(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static void encode(PacketRequestMultiblockUpdate packetGui, FriendlyByteBuf buf) {
        buf.m_130064_(packetGui.blockPos);
    }

    public static PacketRequestMultiblockUpdate decode(FriendlyByteBuf buf) {
        return new PacketRequestMultiblockUpdate(buf.m_130135_());
    }

    public static class Handler {
        public static void handle(PacketRequestMultiblockUpdate message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null) {
                    return;
                }
                BlockEntity blockEntity = player.m_9236_().m_7702_(message.blockPos);
                if (blockEntity != null && blockEntity instanceof BlockEntityMultiCrafter) {
                    BlockEntityMultiCrafter blockEntityMultiCrafter = (BlockEntityMultiCrafter)blockEntity;
                    boolean assembled = blockEntityMultiCrafter.getMultiBlock().isAssembled();
                    PacketHandler.sendTo(new PacketMultiblockUpdate(message.blockPos, assembled), player);
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

