/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.BarrelSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.ChestSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.compat.recipeviewers.common.subtypes.ShulkerBoxSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.item.BarrelBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ChestBlockItem;
import net.p3pp3rf1y.sophisticatedstorage.item.ShulkerBoxItem;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;

public class SubtypeInterpreters {
    private static final PropertyBasedSubtypeInterpreter chestSubtypeInterpreter = new ChestSubtypeInterpreter();
    private static final PropertyBasedSubtypeInterpreter barrelSubtypeInterpreter = new BarrelSubtypeInterpreter();
    private static final PropertyBasedSubtypeInterpreter shulkerBoxSubtypeInterpreter = new ShulkerBoxSubtypeInterpreter();

    public static Map<BlockItem, PropertyBasedSubtypeInterpreter> getSubtypeInterpreters() {
        return new HashMap<BlockItem, PropertyBasedSubtypeInterpreter>(){
            {
                ModBlocks.ITEMS.getEntries().stream().filter(holder -> holder.get() instanceof StorageBlockItem).forEach((? super T item) -> {
                    Item i = (Item)item.get();
                    if (i instanceof BarrelBlockItem) {
                        BarrelBlockItem blockItem = (BarrelBlockItem)i;
                        this.put(blockItem, barrelSubtypeInterpreter);
                    } else if (i instanceof ChestBlockItem) {
                        ChestBlockItem blockItem = (ChestBlockItem)i;
                        this.put(blockItem, chestSubtypeInterpreter);
                    } else if (i instanceof ShulkerBoxItem) {
                        ShulkerBoxItem blockItem = (ShulkerBoxItem)i;
                        this.put(blockItem, shulkerBoxSubtypeInterpreter);
                    }
                });
            }
        };
    }

    public static Optional<PropertyBasedSubtypeInterpreter> getSubtypeInterpreter(Map<BlockItem, PropertyBasedSubtypeInterpreter> subtypeInterpreters, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return Optional.empty();
        }
        BlockItem blockItem = (BlockItem)item;
        return Optional.ofNullable(subtypeInterpreters.get(blockItem));
    }
}

