/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.bakedpipeline;

import com.lowdragmc.lowdraglib.client.bakedpipeline.IQuadTransformer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.ISubmap;
import com.lowdragmc.lowdraglib.client.bakedpipeline.QuadBakingVertexConsumer;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Submap;
import com.lowdragmc.lowdraglib.core.mixins.accessor.VertexFormatAccessor;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
public class Quad {
    private static final TextureAtlasSprite BASE = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
    private final Vector3f[] vertPos;
    private final Vec2[] vertUv;
    private final UVs uvs;
    private final Builder builder;
    private final int blocklight;
    private final int skylight;

    private Quad(Vector3f[] verts, Vec2[] uvs, Builder builder, TextureAtlasSprite sprite) {
        this(verts, uvs, builder, sprite, 0, 0);
    }

    private Quad(Vector3f[] verts, Vec2[] uvs, Builder builder, TextureAtlasSprite sprite, int blocklight, int skylight) {
        this.vertPos = verts;
        this.vertUv = uvs;
        this.builder = builder;
        this.uvs = new UVs(sprite, uvs);
        this.blocklight = blocklight;
        this.skylight = skylight;
    }

    private Quad(Vector3f[] verts, UVs uvs, Builder builder, int blocklight, int skylight) {
        this(verts, uvs.vectorize(), builder, uvs.getSprite(), blocklight, skylight);
    }

    public Vector3f getVert(int index) {
        return new Vector3f((Vector3fc)this.vertPos[index % 4]);
    }

    public Quad withVert(int index, Vector3f vert) {
        Vector3f[] newverts = new Vector3f[4];
        System.arraycopy(this.vertPos, 0, newverts, 0, newverts.length);
        newverts[index] = vert;
        return new Quad(newverts, this.getUvs(), this.builder, this.blocklight, this.skylight);
    }

    public Vec2 getUv(int index) {
        return new Vec2(this.vertUv[index % 4].f_82470_, this.vertUv[index % 4].f_82471_);
    }

    public Quad withUv(int index, Vec2 uv) {
        Vec2[] newuvs = new Vec2[4];
        System.arraycopy(this.getUvs().vectorize(), 0, newuvs, 0, newuvs.length);
        newuvs[index] = uv;
        return new Quad(this.vertPos, new UVs(newuvs), this.builder, this.blocklight, this.skylight);
    }

    public void compute() {
    }

    public Quad[] subdivide(int count) {
        if (count == 1) {
            return new Quad[]{this};
        }
        if (count != 4) {
            throw new UnsupportedOperationException();
        }
        ArrayList<Quad> rects = new ArrayList<Quad>();
        Pair<Quad, Quad> firstDivide = this.divide(false);
        Pair<Quad, Quad> secondDivide = ((Quad)firstDivide.left()).divide(true);
        rects.add((Quad)secondDivide.left());
        if (firstDivide.right() != null) {
            Pair<Quad, Quad> thirdDivide = ((Quad)firstDivide.right()).divide(true);
            rects.add((Quad)thirdDivide.left());
            rects.add((Quad)thirdDivide.right());
        } else {
            rects.add(null);
            rects.add(null);
        }
        rects.add((Quad)secondDivide.right());
        return (Quad[])rects.toArray(Quad[]::new);
    }

    private Pair<Quad, Quad> divide(boolean vertical) {
        float max;
        float min;
        UVs uvs = this.getUvs().normalize();
        if (vertical) {
            min = uvs.minV;
            max = uvs.maxV;
        } else {
            min = uvs.minU;
            max = uvs.maxU;
        }
        if ((double)min < 0.5 && (double)max > 0.5) {
            UVs first = new UVs(vertical ? uvs.minU : 0.5f, vertical ? 0.5f : uvs.minV, uvs.maxU, uvs.maxV, uvs.getSprite());
            UVs second = new UVs(uvs.minU, uvs.minV, vertical ? uvs.maxU : 0.5f, vertical ? 0.5f : uvs.maxV, uvs.getSprite());
            int firstIndex = 0;
            for (int i = 0; i < this.vertUv.length; ++i) {
                if (this.vertUv[i].f_82471_ != this.getUvs().minV || this.vertUv[i].f_82470_ != this.getUvs().minU) continue;
                firstIndex = i;
                break;
            }
            float f = (0.5f - min) / (max - min);
            Vector3f[] firstQuad = new Vector3f[4];
            Vector3f[] secondQuad = new Vector3f[4];
            for (int i = 0; i < 4; ++i) {
                int idx = (firstIndex + i) % 4;
                firstQuad[i] = new Vector3f((Vector3fc)this.vertPos[idx]);
                secondQuad[i] = new Vector3f((Vector3fc)this.vertPos[idx]);
            }
            int i1 = 0;
            int i2 = vertical ? 1 : 3;
            int j1 = vertical ? 3 : 1;
            int j2 = 2;
            firstQuad[i1].set(Quad.lerp(firstQuad[i1].x(), firstQuad[i2].x(), f), Quad.lerp(firstQuad[i1].y(), firstQuad[i2].y(), f), Quad.lerp(firstQuad[i1].z(), firstQuad[i2].z(), f));
            firstQuad[j1].set(Quad.lerp(firstQuad[j1].x(), firstQuad[j2].x(), f), Quad.lerp(firstQuad[j1].y(), firstQuad[j2].y(), f), Quad.lerp(firstQuad[j1].z(), firstQuad[j2].z(), f));
            secondQuad[i2].set(Quad.lerp(secondQuad[i1].x(), secondQuad[i2].x(), f), Quad.lerp(secondQuad[i1].y(), secondQuad[i2].y(), f), Quad.lerp(secondQuad[i1].z(), secondQuad[i2].z(), f));
            secondQuad[j2].set(Quad.lerp(secondQuad[j1].x(), secondQuad[j2].x(), f), Quad.lerp(secondQuad[j1].y(), secondQuad[j2].y(), f), Quad.lerp(secondQuad[j1].z(), secondQuad[j2].z(), f));
            Quad q1 = new Quad(firstQuad, first.relativize(), this.builder, this.blocklight, this.skylight);
            Quad q2 = new Quad(secondQuad, second.relativize(), this.builder, this.blocklight, this.skylight);
            return Pair.of((Object)q1, (Object)q2);
        }
        return Pair.of((Object)this, null);
    }

    public static float lerp(float a, float b, float f) {
        return a * (1.0f - f) + b * f;
    }

    public static float normalize(float min, float max, float x) {
        return (x - min) / (max - min);
    }

    public Quad rotate(int amount) {
        int i;
        Vec2[] uvs = new Vec2[4];
        TextureAtlasSprite s = this.getUvs().getSprite();
        for (i = 0; i < 4; ++i) {
            Vec2 uv;
            Vec2 normalized = new Vec2(Quad.normalize(s.m_118409_(), s.m_118410_(), this.vertUv[i].f_82470_), Quad.normalize(s.m_118411_(), s.m_118412_(), this.vertUv[i].f_82471_));
            uvs[i] = uv = (switch (amount) {
                case 1 -> new Vec2(normalized.f_82471_, 1.0f - normalized.f_82470_);
                case 2 -> new Vec2(1.0f - normalized.f_82470_, 1.0f - normalized.f_82471_);
                case 3 -> new Vec2(1.0f - normalized.f_82471_, normalized.f_82470_);
                default -> new Vec2(normalized.f_82470_, normalized.f_82471_);
            });
        }
        for (i = 0; i < uvs.length; ++i) {
            uvs[i] = new Vec2(Quad.lerp(s.m_118409_(), s.m_118410_(), uvs[i].f_82470_), Quad.lerp(s.m_118411_(), s.m_118412_(), uvs[i].f_82471_));
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad derotate() {
        int start = 0;
        for (int i = 0; i < 4; ++i) {
            if (!(this.vertUv[i].f_82470_ <= this.getUvs().minU) || !(this.vertUv[i].f_82471_ <= this.getUvs().minV)) continue;
            start = i;
            break;
        }
        Vec2[] uvs = new Vec2[4];
        for (int i = 0; i < 4; ++i) {
            uvs[i] = this.vertUv[(i + start) % 4];
        }
        return new Quad(this.vertPos, uvs, this.builder, this.getUvs().getSprite(), this.blocklight, this.skylight);
    }

    public Quad setLight(int blocklight, int skylight) {
        return new Quad(this.vertPos, this.uvs, this.builder, Math.max(this.blocklight, blocklight), Math.max(this.skylight, skylight));
    }

    public BakedQuad rebake() {
        BakedQuad[] quad = new BakedQuad[1];
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer(q -> {
            quad[0] = q;
        });
        builder.setDirection(this.builder.quadOrientation);
        builder.setTintIndex(this.builder.quadTint);
        builder.setShade(this.builder.applyDiffuseLighting);
        builder.setSprite(this.uvs.getSprite());
        VertexFormat format = DefaultVertexFormat.f_85811_;
        for (int v = 0; v < 4; ++v) {
            block6: for (int i = 0; i < format.m_86023_().size(); ++i) {
                VertexFormatElement ele = (VertexFormatElement)format.m_86023_().get(i);
                switch (ele.m_86048_()) {
                    case POSITION: {
                        Vector3f p = this.vertPos[v];
                        builder.m_5483_(p.x(), p.y(), p.z());
                        continue block6;
                    }
                    case COLOR: {
                        int[] c = this.getBuilder().colors[v];
                        builder.m_6122_(c[0], c[1], c[2], c[3]);
                        continue block6;
                    }
                    case UV: {
                        if (ele.m_86049_() == 2) {
                            builder.m_7120_(this.blocklight << 4, this.skylight << 4);
                            continue block6;
                        }
                        if (ele.m_86049_() == 0) {
                            Vec2 uv = this.vertUv[v];
                            builder.m_7421_(uv.f_82470_, uv.f_82471_);
                            continue block6;
                        }
                    }
                    default: {
                        builder.misc(ele, this.builder.packedByElement.get(ele)[v]);
                    }
                }
            }
            builder.m_5752_();
        }
        return quad[0];
    }

    public Quad transformUVs(TextureAtlasSprite sprite) {
        return this.transformUVs(sprite, Submap.FULL_TEXTURE.normalize());
    }

    public Quad transformUVs(TextureAtlasSprite sprite, ISubmap submap) {
        return new Quad(this.vertPos, this.getUvs().transform(sprite, submap), this.builder, this.blocklight, this.skylight);
    }

    public Quad grow() {
        return new Quad(this.vertPos, this.getUvs().normalizeQuadrant(), this.builder, this.blocklight, this.skylight);
    }

    public static Quad from(BakedQuad baked) {
        Builder b = new Builder(baked.m_173410_());
        b.copyFrom(baked, 0.0f);
        return b.build();
    }

    public static Quad from(BakedQuad baked, float offset) {
        Builder b = new Builder(baked.m_173410_());
        b.copyFrom(baked, offset);
        return b.build();
    }

    public String toString() {
        return "Quad(vertPos=" + Arrays.deepToString(this.getVertPos()) + ", vertUv=" + Arrays.deepToString(this.getVertUv()) + ")";
    }

    public Vector3f[] getVertPos() {
        return this.vertPos;
    }

    public Vec2[] getVertUv() {
        return this.vertUv;
    }

    public UVs getUvs() {
        return this.uvs;
    }

    public Builder getBuilder() {
        return this.builder;
    }

    public int getBlocklight() {
        return this.blocklight;
    }

    public int getSkylight() {
        return this.skylight;
    }

    public static class Builder {
        public static final Map<VertexFormatElement, Integer> ELEMENT_OFFSETS = (Map)Util.m_137469_(new IdentityHashMap(), map -> {
            int i = 0;
            for (VertexFormatElement element : DefaultVertexFormat.f_85811_.m_86023_()) {
                map.put(element, ((VertexFormatAccessor)DefaultVertexFormat.f_85811_).getOffsets().getInt(i++) / 4);
            }
        });
        private final TextureAtlasSprite sprite;
        private int quadTint = -1;
        @Nullable
        private Direction quadOrientation;
        private boolean applyDiffuseLighting;
        public final float[][] positions = new float[4][];
        public final float[][] uvs = new float[4][];
        public final int[][] uvs2 = new int[4][];
        public final int[][] colors = new int[4][];
        private Map<VertexFormatElement, int[][]> packedByElement = new HashMap<VertexFormatElement, int[][]>();

        public void copyFrom(BakedQuad baked, float directionOffset) {
            this.setQuadTint(baked.m_111305_());
            this.setQuadOrientation(baked.m_111306_());
            this.setApplyDiffuseLighting(baked.m_111307_());
            int[] vertices = baked.m_111303_();
            for (int i = 0; i < 4; ++i) {
                int offset = i * IQuadTransformer.STRIDE;
                this.positions[i] = new float[]{Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 1]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.POSITION + 2])};
                if (this.quadOrientation != null && directionOffset != 0.0f) {
                    float[] fArray = this.positions[i];
                    fArray[0] = fArray[0] + directionOffset * (float)this.quadOrientation.m_122429_();
                    float[] fArray2 = this.positions[i];
                    fArray2[1] = fArray2[1] + directionOffset * (float)this.quadOrientation.m_122430_();
                    float[] fArray3 = this.positions[i];
                    fArray3[2] = fArray3[2] + directionOffset * (float)this.quadOrientation.m_122431_();
                }
                int packedColor = vertices[offset + IQuadTransformer.COLOR];
                this.colors[i] = new int[]{packedColor & 0xFF, packedColor >> 8 & 0xFF, packedColor >> 16 & 0xFF, packedColor >> 24 & 0xFF};
                this.uvs[i] = new float[]{Float.intBitsToFloat(vertices[offset + IQuadTransformer.UV0]), Float.intBitsToFloat(vertices[offset + IQuadTransformer.UV0 + 1])};
                int lightMap = vertices[offset + IQuadTransformer.UV2];
                this.uvs2[i] = new int[]{lightMap & 0xFFFF, lightMap >> 16 & 0xFFFF};
            }
            for (Map.Entry<VertexFormatElement, Integer> e : ELEMENT_OFFSETS.entrySet()) {
                Integer offset = e.getValue();
                int[][] data = new int[4][e.getKey().m_86050_() / 4];
                for (int v = 0; v < 4; ++v) {
                    for (int i = 0; i < data[v].length; ++i) {
                        data[v][i] = vertices[v * IQuadTransformer.STRIDE + offset + i];
                    }
                }
                this.packedByElement.put(e.getKey(), data);
            }
        }

        public Quad build() {
            Vector3f[] verts = new Vector3f[4];
            Vec2[] uvs = new Vec2[4];
            for (int i = 0; i < verts.length; ++i) {
                verts[i] = new Vector3f(this.positions[i][0], this.positions[i][1], this.positions[i][2]);
                uvs[i] = new Vec2(this.uvs[i][0], this.uvs[i][1]);
            }
            return new Quad(verts, uvs, this, this.getSprite(), this.uvs2[0][0] >> 4, this.uvs2[0][1] >> 4);
        }

        private <T> T[] fromData(List<float[]> data, int size) {
            Vec2[] ret = size == 2 ? new Vec2[data.size()] : new Vector3f[data.size()];
            for (int i = 0; i < data.size(); ++i) {
                ret[i] = size == 2 ? new Vec2(data.get(i)[0], data.get(i)[1]) : new Vector3f(data.get(i)[0], data.get(i)[1], data.get(i)[2]);
            }
            return ret;
        }

        public void setTexture(@Nullable TextureAtlasSprite texture) {
        }

        public Builder(TextureAtlasSprite sprite) {
            this.sprite = sprite;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }

        public int getQuadTint() {
            return this.quadTint;
        }

        public void setQuadTint(int quadTint) {
            this.quadTint = quadTint;
        }

        @Nullable
        public Direction getQuadOrientation() {
            return this.quadOrientation;
        }

        public void setQuadOrientation(@Nullable Direction quadOrientation) {
            this.quadOrientation = quadOrientation;
        }

        public boolean isApplyDiffuseLighting() {
            return this.applyDiffuseLighting;
        }

        public void setApplyDiffuseLighting(boolean applyDiffuseLighting) {
            this.applyDiffuseLighting = applyDiffuseLighting;
        }
    }

    public static class UVs {
        private float minU;
        private float minV;
        private float maxU;
        private float maxV;
        private final TextureAtlasSprite sprite;
        private final Vec2[] data;

        private UVs(Vec2 ... data) {
            this(BASE, data);
        }

        private UVs(TextureAtlasSprite sprite, Vec2 ... data) {
            this.data = data;
            this.sprite = sprite;
            float minU = Float.MAX_VALUE;
            float minV = Float.MAX_VALUE;
            float maxU = 0.0f;
            float maxV = 0.0f;
            for (Vec2 v : data) {
                minU = Math.min(minU, v.f_82470_);
                minV = Math.min(minV, v.f_82471_);
                maxU = Math.max(maxU, v.f_82470_);
                maxV = Math.max(maxV, v.f_82471_);
            }
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
        }

        public UVs(float minU, float minV, float maxU, float maxV, TextureAtlasSprite sprite) {
            this.minU = minU;
            this.minV = minV;
            this.maxU = maxU;
            this.maxV = maxV;
            this.sprite = sprite;
            this.data = this.vectorize();
        }

        public UVs transform(TextureAtlasSprite other, ISubmap submap) {
            UVs normal = this.normalize();
            submap = submap.normalize();
            float width = normal.maxU - normal.minU;
            float height = normal.maxV - normal.minV;
            float minU = submap.getXOffset();
            float minV = submap.getYOffset();
            float maxU = (minU += normal.minU * submap.getWidth()) + width * submap.getWidth();
            float maxV = (minV += normal.minV * submap.getHeight()) + height * submap.getHeight();
            return new UVs(other, new Vec2(this.data[0].f_82470_ == this.minU ? minU : maxU, this.data[0].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[1].f_82470_ == this.minU ? minU : maxU, this.data[1].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[2].f_82470_ == this.minU ? minU : maxU, this.data[2].f_82471_ == this.minV ? minV : maxV), new Vec2(this.data[3].f_82470_ == this.minU ? minU : maxU, this.data[3].f_82471_ == this.minV ? minV : maxV)).relativize();
        }

        UVs normalizeQuadrant() {
            UVs normal = this.normalize();
            int quadrant = normal.getQuadrant();
            float minUInterp = quadrant == 1 || quadrant == 2 ? 0.5f : 0.0f;
            float minVInterp = quadrant < 2 ? 0.5f : 0.0f;
            float maxUInterp = quadrant == 0 || quadrant == 3 ? 0.5f : 1.0f;
            float maxVInterp = quadrant > 1 ? 0.5f : 1.0f;
            normal = new UVs(this.sprite, this.normalize(new Vec2(minUInterp, minVInterp), new Vec2(maxUInterp, maxVInterp), normal.vectorize()));
            return normal.relativize();
        }

        public UVs normalize() {
            Vec2 min = new Vec2(this.sprite.m_118409_(), this.sprite.m_118411_());
            Vec2 max = new Vec2(this.sprite.m_118410_(), this.sprite.m_118412_());
            return new UVs(this.sprite, this.normalize(min, max, this.data));
        }

        public UVs relativize() {
            return this.relativize(this.sprite);
        }

        public UVs relativize(TextureAtlasSprite sprite) {
            Vec2 min = new Vec2(sprite.m_118409_(), sprite.m_118411_());
            Vec2 max = new Vec2(sprite.m_118410_(), sprite.m_118412_());
            return new UVs(sprite, this.lerp(min, max, this.data));
        }

        public Vec2[] vectorize() {
            Vec2[] vec2Array;
            if (this.data == null) {
                Vec2[] vec2Array2 = new Vec2[4];
                vec2Array2[0] = new Vec2(this.minU, this.minV);
                vec2Array2[1] = new Vec2(this.minU, this.maxV);
                vec2Array2[2] = new Vec2(this.maxU, this.maxV);
                vec2Array = vec2Array2;
                vec2Array2[3] = new Vec2(this.maxU, this.minV);
            } else {
                vec2Array = this.data;
            }
            return vec2Array;
        }

        private Vec2[] normalize(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.normalize(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 normalize(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.normalize(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.normalize(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        private Vec2[] lerp(Vec2 min, Vec2 max, Vec2 ... vecs) {
            Vec2[] ret = new Vec2[vecs.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.lerp(min, max, vecs[i]);
            }
            return ret;
        }

        private Vec2 lerp(Vec2 min, Vec2 max, Vec2 vec) {
            return new Vec2(Quad.lerp(min.f_82470_, max.f_82470_, vec.f_82470_), Quad.lerp(min.f_82471_, max.f_82471_, vec.f_82471_));
        }

        public int getQuadrant() {
            if (this.maxU <= 0.5f) {
                if (this.maxV <= 0.5f) {
                    return 3;
                }
                return 0;
            }
            if (this.maxV <= 0.5f) {
                return 2;
            }
            return 1;
        }

        public String toString() {
            return "Quad.UVs(minU=" + this.getMinU() + ", minV=" + this.getMinV() + ", maxU=" + this.getMaxU() + ", maxV=" + this.getMaxV() + ", sprite=" + String.valueOf(this.getSprite()) + ", data=" + Arrays.deepToString(this.data) + ")";
        }

        public float getMinU() {
            return this.minU;
        }

        public float getMinV() {
            return this.minV;
        }

        public float getMaxU() {
            return this.maxU;
        }

        public float getMaxV() {
            return this.maxV;
        }

        public TextureAtlasSprite getSprite() {
            return this.sprite;
        }
    }
}

