/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SelectorWidget;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfiguratorSelectorConfigurator<T>
extends ConfiguratorGroup {
    protected BiConsumer<T, ConfiguratorSelectorConfigurator<T>> configuratorBuilder;
    protected List<T> candidates;
    protected Function<T, String> mapping;
    protected SelectorWidget selector;
    protected int max = 5;
    protected boolean isUp = true;
    protected boolean forceUpdate;
    @Nullable
    protected T value;
    @Nonnull
    protected T defaultValue;
    protected Consumer<T> onUpdate;
    protected Supplier<T> supplier;
    @Nullable
    protected Supplier<List<T>> candidateSupplier;

    public ConfiguratorSelectorConfigurator(String name, boolean isCollapse, Supplier<T> supplier, Consumer<T> onUpdate, @Nonnull T defaultValue, boolean forceUpdate, List<T> candidates, Function<T, String> mapping, BiConsumer<T, ConfiguratorSelectorConfigurator<T>> configuratorBuilder) {
        super(name, isCollapse);
        this.supplier = supplier;
        this.onUpdate = onUpdate;
        this.defaultValue = defaultValue;
        this.forceUpdate = forceUpdate;
        this.value = supplier.get();
        this.candidates = candidates;
        this.mapping = mapping;
        this.configuratorBuilder = configuratorBuilder;
    }

    protected void updateValue() {
        if (this.onUpdate != null) {
            this.onUpdate.accept(this.value);
        }
        this.notifyChanges();
    }

    protected void onValueUpdate(T newValue) {
        if (newValue == null) {
            newValue = this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        this.value = newValue;
        this.selector.setValue(this.mapping.apply(newValue));
        this.removeAllConfigurators();
        if (this.configuratorBuilder != null) {
            this.configuratorBuilder.accept(this.value, this);
        }
        this.computeLayout();
    }

    @Override
    public void updateScreen() {
        super.updateScreen();
        if (this.forceUpdate) {
            this.onValueUpdate(this.supplier.get());
        }
    }

    @Override
    public void init(int width) {
        HashMap<String, T> nameMap = new HashMap<String, T>();
        for (T candidate : this.candidates) {
            nameMap.put(this.mapping.apply(candidate), candidate);
        }
        this.selector = new SelectorWidget(this.leftWidth + 13, 2, width - this.leftWidth - 3 - this.rightWidth - 13, 10, this.candidates.stream().map(this.mapping).toList(), -1).setOnChanged(s -> {
            this.value = nameMap.get(s);
            this.updateValue();
            this.removeAllConfigurators();
            if (this.configuratorBuilder != null) {
                this.configuratorBuilder.accept(this.value, this);
            }
            this.computeLayout();
        }).setMaxCount(this.max).setIsUp(this.isUp).setButtonBackground(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)).setBackground((IGuiTexture)new GuiTextureGroup(ColorPattern.BLACK.rectTexture(), ColorPattern.GRAY.borderTexture(1))).setValue(this.mapping.apply(this.value));
        this.addWidget(this.selector);
        if (this.candidateSupplier != null) {
            this.selector.setCandidatesSupplier(() -> {
                List<T> list = this.candidateSupplier.get();
                this.candidates = list;
                nameMap.clear();
                for (T candidate : this.candidates) {
                    nameMap.put(this.mapping.apply(candidate), candidate);
                }
                return list.stream().map(this.mapping).toList();
            });
        }
        if (this.configuratorBuilder != null) {
            this.configuratorBuilder.accept(this.value, this);
        }
        super.init(width);
    }

    public SelectorWidget getSelector() {
        return this.selector;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public void setUp(boolean isUp) {
        this.isUp = isUp;
    }

    public void setOnUpdate(Consumer<T> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setSupplier(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    @Nullable
    public Supplier<List<T>> getCandidateSupplier() {
        return this.candidateSupplier;
    }

    public void setCandidateSupplier(@Nullable Supplier<List<T>> candidateSupplier) {
        this.candidateSupplier = candidateSupplier;
    }
}

