/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GuiTextureConfigurator
extends ValueConfigurator<IGuiTexture> {
    protected ImageWidget preview;
    protected Consumer<ClickData> onPressCallback;
    protected Predicate<IGuiTexture> available;

    public GuiTextureConfigurator(String name, Supplier<IGuiTexture> supplier, Consumer<IGuiTexture> onUpdate, boolean forceUpdate) {
        super(name, supplier, onUpdate, IGuiTexture.EMPTY, forceUpdate);
        if (this.value == null) {
            this.value = this.defaultValue;
        }
    }

    @Override
    protected void onValueUpdate(IGuiTexture newValue) {
        if (Objects.equals(newValue, this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.preview.setImage(newValue);
    }

    @Override
    public void computeHeight() {
        super.computeHeight();
        this.setSize(new Size(this.getSize().width, 15 + this.preview.getSize().height + 4));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 1 && Editor.INSTANCE != null && this.preview.isMouseOverElement(mouseX, mouseY)) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().leaf(Icons.DELETE, "ldlib.gui.editor.menu.remove", () -> {
                this.onValueUpdate(IGuiTexture.EMPTY);
                this.updateValue();
            }).leaf(Icons.COPY, "ldlib.gui.editor.menu.copy", () -> Editor.INSTANCE.setCopy("texture", this.value));
            if ("texture".equals(Editor.INSTANCE.getCopyType())) {
                menu.leaf(Icons.PASTE, "ldlib.gui.editor.menu.paste", () -> Editor.INSTANCE.ifCopiedPresent("texture", c -> {
                    if (c instanceof IGuiTexture) {
                        IGuiTexture texture = (IGuiTexture)c;
                        this.onValueUpdate(texture);
                        this.updateValue();
                    }
                }));
            }
            Editor.INSTANCE.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    public void init(int width) {
        super.init(width);
        int w = Math.min(width - 6, 50);
        int x = (width - w) / 2;
        this.preview = new ImageWidget(x, 17, w, w, (IGuiTexture)this.value).setBorder(2, ColorPattern.T_WHITE.color);
        this.addWidget(this.preview);
        this.preview.setDraggingConsumer(o -> {
            IGuiTexture texture;
            boolean bl = this.available == null ? o instanceof IGuiTexture || o instanceof Integer || o instanceof String : o instanceof IGuiTexture && this.available.test(texture = (IGuiTexture)o);
            return bl;
        }, o -> this.preview.setBorder(2, ColorPattern.GREEN.color), o -> this.preview.setBorder(2, ColorPattern.T_WHITE.color), o -> {
            IGuiTexture texture;
            IGuiTexture newTexture = null;
            if (this.available != null && o instanceof IGuiTexture && this.available.test(texture = (IGuiTexture)o)) {
                newTexture = texture;
            } else if (o instanceof IGuiTexture) {
                IGuiTexture texture2;
                newTexture = texture2 = (IGuiTexture)o;
            } else if (o instanceof Integer) {
                Integer color = (Integer)o;
                newTexture = new ColorRectTexture(color);
            } else if (o instanceof String) {
                String string = (String)o;
                newTexture = new TextTexture(string);
            }
            if (newTexture != null) {
                this.onValueUpdate(newTexture);
                this.updateValue();
            }
            this.preview.setBorder(2, ColorPattern.T_WHITE.color);
        });
        if (this.onPressCallback != null) {
            this.addWidget(new ButtonWidget(x, 17, w, w, IGuiTexture.EMPTY, this.onPressCallback));
        }
    }

    public void setOnPressCallback(Consumer<ClickData> onPressCallback) {
        this.onPressCallback = onPressCallback;
    }

    public void setAvailable(Predicate<IGuiTexture> available) {
        this.available = available;
    }
}

