/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.configurator;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ValueConfigurator;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;

public class StringConfigurator
extends ValueConfigurator<String> {
    protected TextFieldWidget textFieldWidget;
    protected boolean isResourceLocation;
    protected boolean isCompoundTag;

    public StringConfigurator(String name, Supplier<String> supplier, Consumer<String> onUpdate, @Nonnull String defaultValue, boolean forceUpdate) {
        super(name, supplier, onUpdate, defaultValue, forceUpdate);
    }

    @Override
    protected void onValueUpdate(String newValue) {
        if (newValue == null) {
            newValue = (String)this.defaultValue;
        }
        if (newValue.equals(this.value)) {
            return;
        }
        super.onValueUpdate(newValue);
        this.textFieldWidget.setCurrentString(this.value == null ? this.defaultValue : this.value);
    }

    @Override
    public void init(int width) {
        super.init(width);
        ImageWidget image = new ImageWidget(this.leftWidth, 2, width - this.leftWidth - 3 - this.rightWidth, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        this.addWidget(image);
        image.setDraggingConsumer(o -> !this.isResourceLocation && o instanceof Number || o instanceof String || o instanceof ResourceLocation, o -> image.setImage(ColorPattern.GREEN.rectTexture().setRadius(5.0f)), o -> image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)), o -> {
            if (!this.isResourceLocation && o instanceof Number || o instanceof String || o instanceof ResourceLocation) {
                this.onValueUpdate(o.toString());
                this.updateValue();
            }
            image.setImage(ColorPattern.T_GRAY.rectTexture().setRadius(5.0f));
        });
        this.textFieldWidget = new TextFieldWidget(this.leftWidth + 3, 2, width - this.leftWidth - 6 - this.rightWidth, 10, null, this::onStringUpdate);
        this.addWidget(this.textFieldWidget);
        this.textFieldWidget.setClientSideWidget();
        this.textFieldWidget.setCurrentString(this.value == null ? this.defaultValue : this.value);
        this.textFieldWidget.setBordered(false);
        if (this.isResourceLocation) {
            this.textFieldWidget.setResourceLocationOnly();
        }
        if (this.isCompoundTag) {
            this.textFieldWidget.setCompoundTagOnly();
        }
    }

    private void onStringUpdate(String s) {
        this.value = s;
        this.updateValue();
    }

    public void setResourceLocation(boolean isResourceLocation) {
        this.isResourceLocation = isResourceLocation;
    }

    public void setCompoundTag(boolean isCompoundTag) {
        this.isCompoundTag = isCompoundTag;
    }
}

