/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.ui.resource;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlock;
import com.lowdragmc.lowdraglib.client.renderer.block.RendererBlockEntity;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;

public class IRendererResourceContainer
extends ResourceContainer<IRenderer, Widget> {
    public IRendererResourceContainer(Resource<IRenderer> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setWidgetSupplier(k -> this.createPreview((IRenderer)this.getResource().getResource((Either<String, File>)k)));
        this.setDragging((Either<String, File> key) -> new UIResourceRenderer(resource, (Either<String, File>)key), (k, o, p) -> new TextTexture(resource.getResourceName((Either<String, File>)k)));
        this.setOnEdit(key -> {
            Object patt1582$temp = this.getResource().getResource((Either<String, File>)key);
            if (patt1582$temp instanceof IConfigurable) {
                IConfigurable configurable = (IConfigurable)patt1582$temp;
                this.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, configurable);
            } else {
                this.getPanel().getEditor().getConfigPanel().clearAllConfigurators(ConfigPanel.Tab.RESOURCE);
            }
        });
        this.setCanEdit(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setCanGlobalChange(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setCanRemove(key -> key.left().isEmpty() || !resource.getResourceName((Either<String, File>)key).equals("empty"));
        this.setOnMenu((selected, m) -> m.branch(Icons.ADD_FILE, "ldlib.gui.editor.menu.add_renderer", menu -> {
            for (Map.Entry<String, AnnotationDetector.Wrapper<LDLRegisterClient, ? extends ISerializableRenderer>> entry : AnnotationDetector.REGISTER_RENDERERS.entrySet()) {
                menu.leaf("ldlib.renderer.%s".formatted(entry.getKey()), () -> {
                    ISerializableRenderer renderer = (ISerializableRenderer)((AnnotationDetector.Wrapper)entry.getValue()).creator().get();
                    renderer.initRenderer();
                    resource.addBuiltinResource(this.genNewFileName(), renderer);
                    this.reBuild();
                });
            }
        }));
    }

    protected SceneWidget createPreview(IRenderer renderer) {
        TrackedDummyWorld level = new TrackedDummyWorld();
        level.addBlock(BlockPos.f_121853_, BlockInfo.fromBlock(RendererBlock.BLOCK));
        Optional.ofNullable(level.m_7702_(BlockPos.f_121853_)).ifPresent(blockEntity -> {
            if (blockEntity instanceof RendererBlockEntity) {
                RendererBlockEntity holder = (RendererBlockEntity)((Object)blockEntity);
                holder.setRenderer(renderer);
            }
        });
        SceneWidget sceneWidget = new SceneWidget(0, 0, 50, 50, null);
        sceneWidget.setRenderFacing(false);
        sceneWidget.setRenderSelect(false);
        sceneWidget.setScalable(false);
        sceneWidget.setDraggable(false);
        sceneWidget.setIntractable(false);
        sceneWidget.createScene(level);
        sceneWidget.getRenderer().setOnLookingAt(null);
        sceneWidget.setRenderedCore(Collections.singleton(BlockPos.f_121853_), null);
        return sceneWidget;
    }
}

