/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.data;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.GraphUtils;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.UnknownType;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.TriggerLink;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import oshi.util.tuples.Pair;

public class BaseGraph
implements IPersistedSerializable {
    public final HashSet<UUID> usedGUIDs = new HashSet();
    protected static final int maxComputeOrderDepth = 1000;
    public static final int loopComputeOrder = -2;
    public static final int invalidComputeOrder = -1;
    public final List<BaseNode> nodes = new ArrayList<BaseNode>();
    public final Map<String, BaseNode> nodesPerGUID = new HashMap<String, BaseNode>();
    public final List<PortEdge> edges = new ArrayList<PortEdge>();
    public final Map<String, PortEdge> edgesPerGUID = new HashMap<String, PortEdge>();
    private Map<BaseNode, Integer> computeOrderMap = new HashMap<BaseNode, Integer>();
    public final Map<String, ExposedParameter> exposedParameters = new LinkedHashMap<String, ExposedParameter>();
    public Consumer<ExposedParameter> onParameterValueUpdated;
    public Consumer<GraphChanges> onGraphChanges;
    public final Set<BaseNode> graphOutputs = new HashSet<BaseNode>();
    protected final HashSet<BaseNode> infiniteLoopTracker = new HashSet();

    public UUID newGUID() {
        UUID guid = UUID.randomUUID();
        while (this.usedGUIDs.contains(guid)) {
            guid = UUID.randomUUID();
        }
        this.usedGUIDs.add(guid);
        return guid;
    }

    public void addGUID(String guid) {
        this.usedGUIDs.add(UUID.fromString(guid));
    }

    public void addGUID(UUID guid) {
        this.usedGUIDs.add(guid);
    }

    public int getDepth() {
        return this.nodes.stream().mapToInt(BaseNode::getComputeOrder).max().orElse(0);
    }

    public void resetNodes() {
        this.nodes.forEach(BaseNode::resetNode);
    }

    public BaseGraph() {
    }

    public BaseGraph(List<ExposedParameter<?>> exposedParameters) {
        for (ExposedParameter<?> exposedParameter : exposedParameters) {
            this.exposedParameters.put(exposedParameter.identifier, exposedParameter);
        }
    }

    public void initialize() {
        this.initializeGraphElements();
        this.destroyBrokenGraphElements();
        this.updateComputeOrder(ComputeOrderType.DepthFirst);
    }

    private void initializeGraphElements() {
        this.nodes.removeIf(Objects::isNull);
        this.nodesPerGUID.clear();
        this.edgesPerGUID.clear();
        for (BaseNode node : this.nodes) {
            node.initialize(this);
            this.nodesPerGUID.put(node.getGUID(), node);
        }
        for (PortEdge edge : this.edges) {
            edge.initialize(this);
            this.edgesPerGUID.put(edge.GUID, edge);
            if (edge.inputPort == null || edge.outputPort == null) {
                this.disconnect(edge.GUID);
                continue;
            }
            edge.inputPort.owner.onEdgeConnected(edge);
            edge.outputPort.owner.onEdgeConnected(edge);
        }
    }

    public void onAssetDeleted() {
    }

    public BaseNode addNode(BaseNode node) {
        this.nodes.add(node);
        node.initialize(this);
        this.nodesPerGUID.put(node.getGUID(), node);
        if (this.onGraphChanges != null) {
            this.onGraphChanges.accept(new GraphChanges().addedNode(node));
        }
        return node;
    }

    public void removeNode(BaseNode node) {
        node.disableInternal();
        node.destroyInternal();
        this.nodesPerGUID.remove(node.getGUID());
        this.nodes.remove(node);
        if (this.onGraphChanges != null) {
            this.onGraphChanges.accept(new GraphChanges().removedNode(node));
        }
    }

    public PortEdge connect(NodePort inputPort, NodePort outputPort) {
        return this.connect(inputPort, outputPort, true);
    }

    public PortEdge connect(NodePort inputPort, NodePort outputPort, boolean autoDisconnectInputs) {
        ArrayList<PortEdge> copiedEdges;
        PortEdge edge = PortEdge.createNewEdge(this, inputPort, outputPort);
        boolean hasExistingEdge = this.edges.stream().anyMatch(e -> e.inputPort == edge.inputPort && e.outputPort == edge.outputPort);
        if (hasExistingEdge) {
            return null;
        }
        if (autoDisconnectInputs && !inputPort.portData.acceptMultipleEdges) {
            copiedEdges = new ArrayList<PortEdge>(inputPort.getEdges());
            for (PortEdge e2 : copiedEdges) {
                this.disconnect(e2);
            }
        }
        if (autoDisconnectInputs && !outputPort.portData.acceptMultipleEdges) {
            copiedEdges = new ArrayList<PortEdge>(outputPort.getEdges());
            for (PortEdge e2 : copiedEdges) {
                this.disconnect(e2);
            }
        }
        this.edges.add(edge);
        this.edgesPerGUID.put(edge.GUID, edge);
        inputPort.owner.onEdgeConnected(edge);
        outputPort.owner.onEdgeConnected(edge);
        if (this.onGraphChanges != null) {
            this.onGraphChanges.accept(new GraphChanges().addedEdge(edge));
        }
        return edge;
    }

    public void disconnect(BaseNode inputNode, String inputFieldName, BaseNode outputNode, String outputFieldName) {
        this.edges.removeIf(r -> {
            boolean remove;
            boolean bl = remove = r.inputNode == inputNode && r.outputNode == outputNode && Objects.equals(r.outputFieldName, outputFieldName) && Objects.equals(r.inputFieldName, inputFieldName);
            if (remove) {
                if (r.inputNode != null) {
                    r.inputNode.onEdgeDisconnected((PortEdge)r);
                }
                if (r.outputNode != null) {
                    r.outputNode.onEdgeDisconnected((PortEdge)r);
                }
                if (this.onGraphChanges != null) {
                    this.onGraphChanges.accept(new GraphChanges().removedEdge((PortEdge)r));
                }
            }
            return remove;
        });
    }

    public void disconnect(PortEdge edge) {
        this.disconnect(edge.GUID);
    }

    public void disconnect(String edgeGUID) {
        ArrayList disconnectEvents = new ArrayList();
        this.edges.removeIf(r -> {
            if (Objects.equals(r.GUID, edgeGUID)) {
                disconnectEvents.add(new Pair((Object)r.inputNode, r));
                disconnectEvents.add(new Pair((Object)r.outputNode, r));
                if (this.onGraphChanges != null) {
                    this.onGraphChanges.accept(new GraphChanges().removedEdge((PortEdge)r));
                }
            }
            return Objects.equals(r.GUID, edgeGUID);
        });
        for (Pair tuple : disconnectEvents) {
            if (tuple.getA() == null) continue;
            ((BaseNode)tuple.getA()).onEdgeDisconnected((PortEdge)tuple.getB());
        }
    }

    public ExposedParameter<?> getExposedParameterFromIdentifier(String parameterIdentifier) {
        return this.exposedParameters.get(parameterIdentifier);
    }

    public void updateExposedParameter(String identifier, Object input) {
        ExposedParameter parameter = this.exposedParameters.get(identifier);
        if (parameter != null) {
            parameter.setValue(input);
            if (this.onParameterValueUpdated != null) {
                this.onParameterValueUpdated.accept(parameter);
            }
        }
    }

    public void notifyNodeChanged(BaseNode node) {
        if (this.onGraphChanges != null) {
            this.onGraphChanges.accept(new GraphChanges().nodeChanged(node));
        }
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = IPersistedSerializable.super.serializeNBT();
        ListTag nodes = new ListTag();
        for (BaseNode baseNode : this.nodes) {
            nodes.add((Object)baseNode.serializeNBT());
        }
        tag.m_128365_("nodes", (Tag)nodes);
        ListTag edges = new ListTag();
        for (PortEdge edge : this.edges) {
            edges.add((Object)edge.serializeNBT());
        }
        tag.m_128365_("edges", (Tag)edges);
        CompoundTag compoundTag = new CompoundTag();
        for (ExposedParameter parameter : this.exposedParameters.values()) {
            String identifier = parameter.identifier;
            compoundTag.m_128365_(identifier, (Tag)parameter.serializeNBT());
        }
        tag.m_128365_("parameters", (Tag)compoundTag);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.nodes.removeIf(Objects::isNull);
        if (!this.nodes.isEmpty()) {
            for (BaseNode node : this.nodes) {
                node.disableInternal();
            }
        }
        this.nodes.clear();
        this.edges.clear();
        IPersistedSerializable.super.deserializeNBT(tag);
        ListTag nodes = tag.m_128437_("nodes", 10);
        for (int i = 0; i < nodes.size(); ++i) {
            this.nodes.add(BaseNode.createFromTag(nodes.m_128728_(i)));
        }
        ListTag edges = tag.m_128437_("edges", 10);
        for (int i = 0; i < edges.size(); ++i) {
            PortEdge edge = new PortEdge();
            edge.deserializeNBT(edges.m_128728_(i));
            this.edges.add(edge);
        }
        CompoundTag parameters = tag.m_128469_("parameters");
        for (ExposedParameter parameter : this.exposedParameters.values()) {
            String identifier = parameter.identifier;
            if (!parameters.m_128441_(identifier)) continue;
            parameter.deserializeNBT(parameters.m_128469_(identifier));
        }
        this.initialize();
    }

    public void updateComputeOrder(ComputeOrderType type) {
        if (this.nodes.isEmpty()) {
            return;
        }
        this.graphOutputs.clear();
        for (BaseNode node : this.nodes) {
            if (node.GetOutputNodes().isEmpty()) {
                this.graphOutputs.add(node);
            }
            node.computeOrder = 0;
        }
        this.computeOrderMap.clear();
        this.infiniteLoopTracker.clear();
        if (type == ComputeOrderType.BreadthFirst) {
            for (BaseNode node : this.nodes) {
                this.updateComputeOrderBreadthFirst(0, node);
            }
        } else if (type == ComputeOrderType.DepthFirst) {
            this.updateComputeOrderDepthFirst();
        }
    }

    protected int updateComputeOrderBreadthFirst(int depth, BaseNode node) {
        int computeOrder = 0;
        if (depth > 1000) {
            LDLib.LOGGER.error("Recursion error while updating compute order");
            return -1;
        }
        if (this.computeOrderMap.containsKey(node)) {
            return node.computeOrder;
        }
        if (!this.infiniteLoopTracker.add(node)) {
            return -1;
        }
        if (!node.canProcess) {
            node.computeOrder = -1;
            this.computeOrderMap.put(node, -1);
            return -1;
        }
        for (BaseNode dep : node.getInputNodes()) {
            int c = this.updateComputeOrderBreadthFirst(depth + 1, dep);
            if (c == -1) {
                computeOrder = -1;
                break;
            }
            computeOrder += c;
        }
        if (computeOrder != -1) {
            ++computeOrder;
        }
        node.computeOrder = computeOrder;
        this.computeOrderMap.put(node, computeOrder);
        return computeOrder;
    }

    protected void updateComputeOrderDepthFirst() {
        Stack dfs = new Stack();
        GraphUtils.FindCyclesInGraph(this, n -> this.propagateComputeOrder((BaseNode)n, -2));
        int computeOrder = 0;
        for (BaseNode node : GraphUtils.DepthFirstSort(this)) {
            if (node.computeOrder == -2) continue;
            if (!node.canProcess) {
                node.computeOrder = -1;
                continue;
            }
            node.computeOrder = computeOrder++;
        }
    }

    protected void propagateComputeOrder(BaseNode node, int computeOrder) {
        Stack<BaseNode> deps = new Stack<BaseNode>();
        HashSet<BaseNode> loop = new HashSet<BaseNode>();
        deps.push(node);
        while (!deps.isEmpty()) {
            BaseNode n = (BaseNode)deps.pop();
            n.computeOrder = computeOrder;
            if (!loop.add(n)) continue;
            for (BaseNode dep : n.GetOutputNodes()) {
                deps.push(dep);
            }
        }
    }

    void destroyBrokenGraphElements() {
        this.edges.removeIf(e -> e.inputNode == null || e.outputNode == null || e.outputFieldName == null || e.outputFieldName.isEmpty() || e.inputFieldName == null || e.inputFieldName.isEmpty());
        this.nodes.removeIf(Objects::isNull);
    }

    public static boolean areTypesConnectable(Class from, Class to) {
        if (from == TriggerLink.class || to == TriggerLink.class) {
            return from == to;
        }
        if (from == null || to == null) {
            return false;
        }
        if (TypeAdapter.areIncompatible(from, to)) {
            return false;
        }
        if (to.isAssignableFrom(from)) {
            return true;
        }
        if (to == Object.class) {
            return true;
        }
        if (from == UnknownType.class || from == Object.class) {
            return true;
        }
        return TypeAdapter.areConvertable(from, to);
    }

    public static enum ComputeOrderType {
        DepthFirst,
        BreadthFirst;

    }

    public static class GraphChanges {
        public PortEdge removedEdge;
        public PortEdge addedEdge;
        public BaseNode removedNode;
        public BaseNode addedNode;
        public BaseNode nodeChanged;

        public GraphChanges removedEdge(PortEdge removedEdge) {
            this.removedEdge = removedEdge;
            return this;
        }

        public GraphChanges addedEdge(PortEdge addedEdge) {
            this.addedEdge = addedEdge;
            return this;
        }

        public GraphChanges removedNode(BaseNode removedNode) {
            this.removedNode = removedNode;
            return this;
        }

        public GraphChanges addedNode(BaseNode addedNode) {
            this.addedNode = addedNode;
            return this;
        }

        public GraphChanges nodeChanged(BaseNode nodeChanged) {
            this.nodeChanged = nodeChanged;
            return this;
        }
    }
}

