/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes;

import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortInput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import java.util.ArrayList;
import java.util.List;

public abstract class ListInputNode<I>
extends BaseNode {
    @InputPort
    public List<I> inputs = new ArrayList<I>();

    public abstract Class<I> type();

    @CustomPortBehavior(field="inputs")
    public List<PortData> inputPortBehavior(List<PortEdge> edges) {
        ArrayList<PortData> ports = new ArrayList<PortData>();
        for (int i = 0; i < edges.size() + 1; ++i) {
            String identifier = String.valueOf(i);
            if (i < edges.size()) {
                PortEdge edge = edges.get(i);
                edge.inputPortIdentifier = identifier;
            }
            ports.add(new PortData().displayName("in " + i).identifier(identifier).displayType(this.type()));
        }
        if (this.inputs == null) {
            this.inputs = new ArrayList<I>();
        }
        this.inputs.clear();
        while (this.inputs.size() + 1 < ports.size()) {
            this.inputs.add(null);
        }
        return ports;
    }

    @CustomPortInput(field="inputs")
    public void pullInputs(List<PortEdge> inputEdges, NodePort inputPort) {
        if (inputEdges.isEmpty()) {
            return;
        }
        Object value = null;
        for (PortEdge inputEdge : inputEdges) {
            if (inputEdge.passThroughBuffer == null || !this.type().isAssignableFrom(inputEdge.passThroughBuffer.getClass())) continue;
            value = inputEdge.passThroughBuffer;
            break;
        }
        int index = inputPort.owner.getInputPorts().indexOf(inputPort);
        while (this.inputs.size() <= index) {
            this.inputs.add(value);
        }
        this.inputs.set(index, value);
    }
}

