/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.DraggablePanelWidget;
import com.lowdragmc.lowdraglib.gui.graphprocessor.widget.GraphViewWidget;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.layout.Layout;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class NodePanelWidget
extends DraggablePanelWidget {
    private final GraphViewWidget graphView;
    private DraggableScrollableWidgetGroup nodeListView;
    private String filter = "";
    @Nullable
    private String selectedNode;
    private long lastClickTime;
    private Map<String, NodeGroupWidget> nodeGroupWidgets = new HashMap<String, NodeGroupWidget>();

    public NodePanelWidget(GraphViewWidget graphView, int x, int y, int width, int height) {
        super("graph_processor.node_panel", x, y, width, height);
        this.graphView = graphView;
    }

    @Override
    protected void loadWidgets() {
        super.loadWidgets();
        this.nodeListView = new DraggableScrollableWidgetGroup(3, 12, this.content.getSizeWidth() - 6, this.content.getSizeHeight() - 15);
        this.nodeListView.setYScrollBarWidth(2).setYBarStyle(null, ColorPattern.T_WHITE.rectTexture().setRadius(1.0f));
        WidgetGroup groupContainer = new WidgetGroup(Position.ORIGIN);
        groupContainer.setLayout(Layout.VERTICAL_LEFT);
        groupContainer.setLayoutPadding(2);
        for (Map.Entry<String, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>>> entry : this.graphView.getNodeGroups().entrySet()) {
            NodeGroupWidget nodeGroupWidget = new NodeGroupWidget(entry.getKey(), entry.getValue(), this.nodeListView.getSizeWidth() - 3);
            this.nodeGroupWidgets.put(entry.getKey(), nodeGroupWidget);
            groupContainer.addWidget(nodeGroupWidget);
        }
        this.nodeListView.addWidget(groupContainer);
        this.content.addWidget(this.nodeListView);
        this.content.addWidget(new LabelWidget(2, 2, "Search:"));
        int length = Minecraft.m_91087_().f_91062_.m_92895_("Search:");
        this.content.addWidget(new ImageWidget(5 + length, 2, this.content.getSizeWidth() - 8 - length, 10, ColorPattern.T_GRAY.rectTexture().setRadius(5.0f)));
        this.content.addWidget(new TextFieldWidget(8 + length, 2, this.content.getSizeWidth() - 8 - length, 10, () -> this.filter, s -> {
            this.filter = s;
            this.nodeGroupWidgets.values().forEach(NodeGroupWidget::reloadNodes);
            for (NodeGroupWidget groupWidget : this.nodeGroupWidgets.values()) {
                if (groupWidget.nodesGroup.widgets.isEmpty()) continue;
                groupWidget.collapse(false);
            }
        }).setCurrentString(this.filter).setBordered(false).setClientSideWidget());
    }

    public GraphViewWidget getGraphView() {
        return this.graphView;
    }

    public DraggableScrollableWidgetGroup getNodeListView() {
        return this.nodeListView;
    }

    public String getFilter() {
        return this.filter;
    }

    @Nullable
    public String getSelectedNode() {
        return this.selectedNode;
    }

    public long getLastClickTime() {
        return this.lastClickTime;
    }

    public Map<String, NodeGroupWidget> getNodeGroupWidgets() {
        return this.nodeGroupWidgets;
    }

    private class NodeGroupWidget
    extends WidgetGroup {
        private final WidgetGroup nodesGroup;
        private final ImageWidget splitLine;
        private final List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>> nodes;

        public NodeGroupWidget(String groupName, List<AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode>> nodes, int width) {
            super(0, 0, width, 0);
            this.nodes = nodes;
            this.nodesGroup = new WidgetGroup(new Position(2, 16));
            this.nodesGroup.setLayout(Layout.VERTICAL_LEFT);
            this.setBackground(ColorPattern.WHITE.borderTexture(-1));
            this.splitLine = new ImageWidget(2, 2, width - 4, 11, ColorPattern.LIGHT_GRAY.rectTexture());
            this.addWidget(this.splitLine);
            this.addWidget(new ButtonWidget(2, 2, width - 4, 11, new TextTexture(groupName).setType(TextTexture.TextType.ROLL).setWidth(width - 4), b -> this.collapse(!this.isCollapsed())));
            this.addWidget(this.nodesGroup);
            this.reloadNodes();
            this.collapse(true);
        }

        public boolean isCollapsed() {
            return !this.splitLine.isVisible();
        }

        public void collapse(boolean collapse) {
            if (this.isCollapsed() == collapse) {
                return;
            }
            if (collapse) {
                this.splitLine.setVisible(false);
                this.splitLine.setActive(false);
                this.nodesGroup.setVisible(false);
                this.nodesGroup.setActive(false);
                this.setSize(this.getSizeWidth(), 15);
            } else {
                this.splitLine.setVisible(true);
                this.splitLine.setActive(true);
                this.nodesGroup.setVisible(true);
                this.nodesGroup.setActive(true);
                this.setSize(this.getSizeWidth(), 15 + this.nodesGroup.getSizeHeight() + 2);
            }
        }

        public void reloadNodes() {
            int width = this.getSizeWidth();
            this.nodesGroup.clearAllWidgets();
            for (AnnotationDetector.Wrapper<LDLRegister, ? extends BaseNode> node : this.nodes) {
                if (!node.annotation().name().contains(NodePanelWidget.this.filter) && !node.annotation().group().contains(NodePanelWidget.this.filter)) continue;
                WidgetGroup buttonGroup = new WidgetGroup(0, 0, width - 4, 10);
                buttonGroup.addWidget(new ButtonWidget(0, 0, width - 4, 10, new TextTexture(node.annotation().name()).setType(TextTexture.TextType.LEFT_HIDE).setWidth(width - 4), b -> {
                    if (this.gui == null) {
                        return;
                    }
                    if (!((LDLRegister)node.annotation()).name().equals(NodePanelWidget.this.selectedNode)) {
                        NodePanelWidget.this.selectedNode = ((LDLRegister)node.annotation()).name();
                        NodePanelWidget.this.lastClickTime = this.gui.getTickCount();
                    } else {
                        long currentClickTime = this.gui.getTickCount();
                        if (currentClickTime - NodePanelWidget.this.lastClickTime < 10L) {
                            NodePanelWidget.this.graphView.addNodeToCenter((BaseNode)node.creator().get());
                            NodePanelWidget.this.lastClickTime = currentClickTime - 10L;
                        } else {
                            NodePanelWidget.this.lastClickTime = currentClickTime;
                        }
                    }
                }));
                buttonGroup.addWidget(new ImageWidget(0, 0, width - 4, 10, () -> ((LDLRegister)node.annotation()).name().equals(NodePanelWidget.this.selectedNode) ? ColorPattern.T_GRAY.rectTexture() : IGuiTexture.EMPTY).setDraggingProvider(() -> (BaseNode)node.creator().get(), (n, pos) -> new TextTexture(n.getDisplayName())));
                this.nodesGroup.addWidget(buttonGroup);
            }
            if (this.nodesGroup.widgets.isEmpty()) {
                this.setSize(this.getSizeWidth(), 0);
                this.setVisible(false);
                this.setActive(false);
            } else {
                if (this.isCollapsed()) {
                    this.setSize(this.getSizeWidth(), 15);
                } else {
                    this.setSize(this.getSizeWidth(), 15 + this.nodesGroup.getSizeHeight() + 2);
                }
                this.setVisible(true);
                this.setActive(true);
            }
        }
    }
}

