/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberColor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@Configurable(name="ldlib.gui.editor.register.widget.label", collapse=false)
@LDLRegister(name="label", group="widget.basic")
public class LabelWidget
extends Widget
implements IConfigurableWidget {
    @Nonnull
    protected Supplier<String> textSupplier;
    @Nullable
    protected Component component;
    @Configurable(name="ldlib.gui.editor.name.text")
    private String lastTextValue = "";
    @Configurable(name="ldlib.gui.editor.name.color")
    @NumberColor
    private int color;
    @Configurable(name="ldlib.gui.editor.name.isShadow")
    private boolean dropShadow;

    public LabelWidget() {
        this(0, 0, "label");
    }

    public LabelWidget(int xPosition, int yPosition, String text) {
        this(xPosition, yPosition, () -> text);
    }

    public LabelWidget(int xPosition, int yPosition, Component component) {
        super(new Position(xPosition, yPosition), new Size(10, 10));
        this.setDropShadow(true);
        this.setTextColor(-1);
        this.setComponent(component);
    }

    public LabelWidget(int xPosition, int yPosition, Supplier<String> text) {
        super(new Position(xPosition, yPosition), new Size(10, 10));
        this.setDropShadow(true);
        this.setTextColor(-1);
        this.setTextProvider(text);
    }

    @ConfigSetter(field="lastTextValue")
    public void setText(String text) {
        this.textSupplier = () -> text;
        if (this.isRemote()) {
            this.lastTextValue = this.textSupplier.get();
            this.updateSize();
        }
    }

    public void setTextProvider(Supplier<String> textProvider) {
        this.textSupplier = textProvider;
        if (this.isRemote()) {
            this.lastTextValue = this.textSupplier.get();
            this.updateSize();
        }
    }

    public void setComponent(Component component) {
        this.component = component;
        if (this.isRemote()) {
            this.lastTextValue = component.getString();
            this.updateSize();
        }
    }

    @Deprecated
    public LabelWidget setTextColor(int color) {
        this.color = color;
        if (this.component != null) {
            this.component = this.component.m_6881_().m_130948_(this.component.m_7383_().m_178520_(color));
        }
        return this;
    }

    @Deprecated
    public LabelWidget setDropShadow(boolean dropShadow) {
        this.dropShadow = dropShadow;
        return this;
    }

    public void setColor(int color) {
        this.setTextColor(color);
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        if (!this.isClientSideWidget) {
            if (this.component != null) {
                buffer.writeBoolean(true);
                buffer.m_130083_(this.component);
            } else {
                buffer.writeBoolean(false);
                this.lastTextValue = this.textSupplier.get();
                buffer.m_130070_(this.lastTextValue);
            }
        } else {
            buffer.writeBoolean(false);
            buffer.m_130070_(this.lastTextValue);
        }
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        if (buffer.readBoolean()) {
            this.component = buffer.m_130238_();
            this.lastTextValue = this.component.getString();
        } else {
            this.lastTextValue = buffer.m_130277_();
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.isClientSideWidget) {
            String latest;
            if (this.component != null && !(latest = this.component.getString()).equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.writeUpdateInfo(-2, buffer -> buffer.m_130083_(this.component));
            }
            if (!(latest = this.textSupplier.get()).equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.writeUpdateInfo(-1, buffer -> buffer.m_130070_(this.lastTextValue));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.lastTextValue = buffer.m_130277_();
            this.updateSize();
        } else if (id == -2) {
            this.component = buffer.m_130238_();
            this.lastTextValue = this.component.getString();
            this.updateSize();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget) {
            String latest;
            String string = latest = this.component == null ? this.textSupplier.get() : this.component.getString();
            if (!latest.equals(this.lastTextValue)) {
                this.lastTextValue = latest;
                this.updateSize();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void updateSize() {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        int n = this.component == null ? fontRenderer.m_92895_(LocalizationUtils.format(this.lastTextValue, new Object[0])) : fontRenderer.m_92852_((FormattedText)this.component);
        Objects.requireNonNull(fontRenderer);
        this.setSize(new Size(n, 9));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        Position position = this.getPosition();
        if (this.component == null) {
            String suppliedText = LocalizationUtils.format(this.lastTextValue, new Object[0]);
            String[] split = suppliedText.split("\n");
            for (int i = 0; i < split.length; ++i) {
                int n = position.y;
                Objects.requireNonNull(fontRenderer);
                int y = n + i * (9 + 2);
                graphics.m_280056_(fontRenderer, split[i], position.x, y, this.color, this.dropShadow);
            }
        } else {
            graphics.m_280614_(fontRenderer, this.component, position.x, position.y, this.color, this.dropShadow);
        }
    }

    @Override
    public boolean handleDragging(Object dragging) {
        if (dragging instanceof String) {
            String string = (String)dragging;
            this.setText(string);
            return true;
        }
        return IConfigurableWidget.super.handleDragging(dragging);
    }

    public void setTextSupplier(@Nonnull Supplier<String> textSupplier) {
        if (textSupplier == null) {
            throw new NullPointerException("textSupplier is marked non-null but is null");
        }
        this.textSupplier = textSupplier;
    }
}

